//
//  IBXModeCustomTokenUtil.m
//  IBXSDK_Example
//
//  Created by yeming on 2020/10/12.
//  Copyright © 2020 yemingxu. All rights reserved.
//

#import "IBXModeCustomTokenUtil.h"
#import <IBXSDK/IBXSDK.h>
#import <AdSupport/AdSupport.h>
#import <YYKit.h>

@implementation IBXModeCustomTokenUtil
+ (NSString *)deviceId{
    NSString *result = ASIdentifierManager.sharedManager.advertisingIdentifier.UUIDString;
    return result;
}
+ (NSString *)device{
    return @"ios";
}
+ (NSString *)appKey{
    return [IBXSDKConfig getAppKey];
}
+ (NSString *)targetId{
    return [IBXSDKConfig getTargetId];
}
+ (NSString *)secretKey{
    return [IBXSDKConfig getSecretKey];
}
+ (NSString *)notify_url{
    return [IBXSDKConfig getNotifyUrl];

}
+ (NSString *)getSign{
    NSString * notify_url = self.notify_url;
    notify_url = notify_url.length ? notify_url : @"";
    
    NSString *string = [NSString stringWithFormat:@"%@%@%@%@%@%@",self.appKey,self.device,self.deviceId,self.targetId,notify_url,self.secretKey];
    NSString *sign = [string md5String];
    return [sign uppercaseString];
}
+ (NSDictionary *)requestParams{
    NSMutableDictionary *params = [NSMutableDictionary dictionary];
    params[@"app_key"] = self.appKey;
    params[@"device"] = self.device;
    params[@"device_info"] = self.deviceId;
    params[@"sign"] = self.getSign;
    params[@"target_id"] = self.targetId;
    params[@"notify_url"] = self.notify_url;
    return [NSDictionary dictionaryWithDictionary:params];
}
+ (NSString *)requestParamsString{
    NSDictionary *params = [self requestParams];
    
    NSMutableArray<NSString *> *items = [NSMutableArray array];
    [params enumerateKeysAndObjectsUsingBlock:^(id  _Nonnull key, id  _Nonnull obj, BOOL * _Nonnull stop) {
        NSString *item = [NSString stringWithFormat:@"%@=%@",key,obj];
        [items addObject:item];
    }];
    return [items componentsJoinedByString:@"&"];
}





+ (void)loadToken:(void(^)(BOOL success,NSString *token))completed{
    
    NSString *deviceId = self.deviceId;
    
    if (deviceId == nil || deviceId.length == 0) {
        completed(false, nil);
        return;
    }
    
    NSString *params = [self requestParamsString];
    
    //直接发送POST请求
    NSURL *url = [NSURL URLWithString:@"https://api.aibianxian.net/igame/api/v1.2/cplApi/access"];
    
    
    NSMutableURLRequest *request = [NSMutableURLRequest requestWithURL:url];
    request.HTTPMethod = @"POST";
    request.HTTPBody = [params dataUsingEncoding:NSUTF8StringEncoding];
    NSLog(@"%@",params);
    
    NSURLSession *session = [NSURLSession sharedSession];
    NSURLSessionDataTask *dataTask = [session dataTaskWithRequest:request completionHandler:^(NSData * _Nullable data, NSURLResponse * _Nullable response, NSError * _Nullable error) {
        if (error) {
            NSLog(@"%@",error.description);
            dispatch_sync(dispatch_get_main_queue(), ^{
                completed(false,nil);
            });
            return;
        }
        NSError *json_error;
        NSDictionary *dict = [NSJSONSerialization JSONObjectWithData:data options:NSJSONReadingAllowFragments error:&json_error];
        if (json_error){
            dispatch_sync(dispatch_get_main_queue(), ^{
                completed(false, nil);
            });
            return;
        }
        NSLog(@"%@",dict);
        
        // 检测返回值
        NSString *code = dict[@"code"];
        //                NSString *message = dict[@"message"];
        
        if (![code isEqualToString:@"200"]){
            dispatch_sync(dispatch_get_main_queue(), ^{
                completed(false,  nil);
            });
            return;
        }
        
        NSDictionary *data_dict = dict[@"data"];
        NSString *token = data_dict[@"token"];
        dispatch_sync(dispatch_get_main_queue(), ^{
            completed(true, token);
        });
    }];
    
    
    //必须启动任务，否则不会走block中的回调
    [dataTask resume];
    
}

@end
