//
//  IBXModeCustomViewController.m
//  IBXSDK_Example
//
//  Created by yeming on 2020/10/12.
//  Copyright © 2020 yemingxu. All rights reserved.
//

#import "IBXModeCustomViewController.h"
#import "IBXSDKHelper.h"
#import "IBXModeCustomViewModel.h"
#import "IBXModeWebViewController.h"

@interface IBXModeCustomViewController ()<UITableViewDelegate,UITableViewDataSource>
@property (nonatomic,strong) UITableView *rootTableView;
@property (nonatomic,strong) IBXModeCustomViewModel *VM;
@end
@implementation IBXModeCustomViewController


- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    __weak typeof(self) weakSelf = self;
    [self.VM prepare:^(BOOL success) {
        if (!success){
            // 准备失败
            [weakSelf.navigationController popViewControllerAnimated:YES];
            return;
        }
        
        [weakSelf loadUI];
        [weakSelf.VM reload:^(BOOL success1) {
            if (!success1) return;
            
            [weakSelf.rootTableView reloadData];
        }];
    }];

}
#pragma mark - <UITableViewDelegate,UITableViewDataSource>
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView{
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section{
    return self.VM.list.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"CELL" forIndexPath:indexPath];
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    IBXModeCustomGameData *data = self.VM.list[indexPath.row];
    cell.textLabel.text = data.name;
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    IBXModeCustomGameData *data = self.VM.list[indexPath.row];
    NSString *urlString = [data.gameDetailUrl stringByAppendingFormat:@"?token=%@",self.VM.token];
    // 打开详情
    IBXModeWebViewController *vc = [[IBXModeWebViewController alloc] initWithUrlString:urlString];
    [self.navigationController pushViewController:vc animated:YES];
}

#pragma mark - UI
- (void)loadUI{
    self.view.backgroundColor = UIColor.whiteColor;
    self.title = IBXDisplayModesDescribe(IBXDisplayMode_Custom);
    CGRect frame = self.view.bounds;
    CGFloat navigationBarHeight = [IBXSDKHelper navigationBarHeight];
    self.rootTableView.frame = (CGRect){0,navigationBarHeight,frame.size.width,frame.size.height - navigationBarHeight};
    [self.view addSubview:self.rootTableView];
}

#pragma mark - Lazys
- (UITableView *)rootTableView{
    if (!_rootTableView) {
        _rootTableView = [[UITableView alloc] initWithFrame:self.view.bounds style:(UITableViewStylePlain)];
        [_rootTableView registerClass:UITableViewCell.class forCellReuseIdentifier:@"CELL"];
        _rootTableView.delegate = self;
        _rootTableView.dataSource = self;
    }
    return _rootTableView;
}

- (IBXModeCustomViewModel *)VM{
    if (!_VM) {
        _VM = [[IBXModeCustomViewModel alloc] init];
    }
    return _VM;
}

@end
