//
//  IBXModeCustomViewModel.m
//  IBXSDK_Example
//
//  Created by yeming on 2020/10/12.
//  Copyright © 2020 yemingxu. All rights reserved.
//

#import "IBXModeCustomViewModel.h"
#import <IBXSDK/IBXSDK.h>
#import "IBXModeCustomTokenUtil.h"
#import <MJExtension/MJExtension.h>

@interface IBXModeCustomResponseData : NSObject
@property (nonatomic, copy)   NSArray<IBXModeCustomGameData *> *records;
@property (nonatomic, assign) NSInteger total;
@property (nonatomic, assign) NSInteger size;
@property (nonatomic, assign) NSInteger current;
@property (nonatomic, assign) BOOL isSearchCount;
@property (nonatomic, assign) NSInteger pages;
@end
@interface IBXModeCustomResponse : NSObject
@property (nonatomic, copy)   NSString *code;
@property (nonatomic, copy)   NSString *message;
@property (nonatomic, strong) IBXModeCustomResponseData *data;
@end

@implementation IBXModeCustomResponseData
+ (void)initialize{
    [self mj_setupObjectClassInArray:^NSDictionary *{
        return @{@"records": @"IBXModeCustomGameData"};
    }];
}
@end

@implementation IBXModeCustomResponse

@end

@interface IBXModeCustomViewModel()

@property (nonatomic,assign) int pageNum;
@end
@implementation IBXModeCustomViewModel
#pragma mark - 准备
- (void)prepare:(void(^)(BOOL success))completed{
    __weak typeof(self) weakSelf = self;
    [IBXModeCustomTokenUtil loadToken:^(BOOL success, NSString *token) {
        if (success) {
            weakSelf.token = token;
        }
        if (completed) {
            completed(success);
        }
    }];
}
#pragma mark - 列表加载
/**
 重新加载
 */
- (void)reload:(void(^)(BOOL success))completed{
    self.pageNum = 0;
    [self loadmore:completed];
}

/**
 加载更多
 */
- (void)loadmore:(void(^)(BOOL success))completed{
    self.pageNum += 1;
    
    __weak typeof(self) weakSelf = self;
    
    NSString *urlString = [self getRequestUrlString];
    NSMutableURLRequest *request = [NSMutableURLRequest requestWithURL:[NSURL URLWithString:urlString]];
    request.HTTPMethod = @"GET";

    NSURLSession *session = [NSURLSession sharedSession];
    NSURLSessionDataTask *dataTask = [session dataTaskWithRequest:request completionHandler:^(NSData * _Nullable data, NSURLResponse * _Nullable response, NSError * _Nullable error) {
        if (error) {
            NSLog(@"%@",error.description);
            dispatch_sync(dispatch_get_main_queue(), ^{
                completed(false);
            });
            return;

        }
        NSError *json_error;
        NSDictionary *dict = [NSJSONSerialization JSONObjectWithData:data options:NSJSONReadingAllowFragments error:&json_error];
        if (json_error){
            dispatch_sync(dispatch_get_main_queue(), ^{
                completed(false);
            });
            return;
        }
        NSLog(@"%@",dict);
        IBXModeCustomResponse *resp = [IBXModeCustomResponse mj_objectWithKeyValues:dict];
        // 检测返回值
        if (![resp.code isEqualToString:@"200"]){
            dispatch_sync(dispatch_get_main_queue(), ^{
                completed(false);
            });
            return;
        }
        BOOL isNoMore = (resp.data.current >= resp.data.pages);
        weakSelf.isNoMore = isNoMore;
        if (weakSelf.pageNum == 1){
            [weakSelf.list removeAllObjects];
        }
        [weakSelf.list addObjectsFromArray:resp.data.records];
        dispatch_sync(dispatch_get_main_queue(), ^{
            completed(true);
        });
    }];

    
    //必须启动任务，否则不会走block中的回调
    [dataTask resume];
}

/**
 格式化参数
 */
- (NSString *)getRequestUrlString{
    NSString *urlString = @"https://api.aibianxian.net/igame/api/v1.0/cplApi/listGameByTargetId";


    NSMutableDictionary *params = [NSMutableDictionary dictionary];
    params[@"pageNum"] = @(self.pageNum);
    params[@"pageSize"] = @(10);
    params[@"appKey"] = [IBXSDKConfig getAppKey];
    params[@"targetId"] = [IBXSDKConfig getTargetId];
    NSMutableArray<NSString *> *paramsList = [NSMutableArray array];
    for (NSString *key in params.allKeys) {
        [paramsList addObject:[key stringByAppendingFormat:@"=%@",params[key]]];
    }
    urlString = [urlString stringByAppendingFormat:@"?%@",[paramsList componentsJoinedByString:@"&"]];
    
    NSLog(@"%@",params);
    return urlString;
}
- (NSMutableArray<IBXModeCustomGameData *> *)list{
    if (!_list) {
        _list = [NSMutableArray array];
    }
    return _list;
}
@end
