//
//  CustomViewController.m
//  IBXDemo
//
//  Created by yeming on 2020/6/28.
//  Copyright © 2020 yeming. All rights reserved.
//

#import "CustomViewController.h"
#import <IBXSDK/IBXSDK.h>
#import <IBXSDK/IBXSDKWebContentController.h>
#import "IBXSDKHelper.h"

@interface CustomViewController ()<IBXSDKWebContentDelegate>
@property (nonatomic,strong) IBXSDKWebContentController *ibx_contentController;
@end

@implementation CustomViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self setupUI];
    
    // 请求主页链接
    typeof(self) weakSelf = self;
    [IBXSDK requestHomeUrl:^(NSString *urlString, NSError *error) {
        if (error){
            NSLog(@"%@",error);
            return;
        }
        [weakSelf.ibx_contentController resetUrlString:urlString];
    }];
    
}
- (void)setupUI{
    if (_ibx_contentController){
        return;
    }
    _ibx_contentController = [[IBXSDKWebContentController alloc] init];
    _ibx_contentController.delegate = IBXSDKHelper.sharedInstance;
    _ibx_contentController.contentDelegate = self;
    [self addChildViewController:self.ibx_contentController];
    [self.view addSubview:self.ibx_contentController.view];
    self.ibx_contentController.view.frame = self.view.bounds;
}

#pragma mark - IBXSDKWebContentDelegate
- (void)ibxsdk_webContentDidUpdateWebTitle:(NSString *)webtitle{
    self.title = webtitle;
}

- (void)ibxsdk_webContentDidUpdateWebProgress:(double)webprogress{
    NSLog(@"%@ -> %f",NSStringFromSelector(_cmd), webprogress);
}


- (BOOL)prefersHomeIndicatorAutoHidden{
    return true;
}
@end
