//
//  IBXModeH5ViewController.m
//  IBXSDK_Example
//
//  Created by yeming on 2020/10/12.
//  Copyright © 2020 yemingxu. All rights reserved.
//

#import "IBXModeH5ViewController.h"
#import <IBXSDK/IBXSDK.h>
//#import "WXApi.h"
#import "IBXSDKHelper.h"
#import "IBXModeWebViewController.h"

@interface IBXModeH5ViewController ()

@end

@implementation IBXModeH5ViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor = UIColor.whiteColor;
    self.title = IBXDisplayModesDescribe(IBXDisplayMode_H5);

    // Do any additional setup after loading the view.
    UIButton *openBtn = [UIButton buttonWithType:(UIButtonTypeCustom)];
    openBtn.titleLabel.font = [UIFont systemFontOfSize:30];
    [openBtn setTitleColor:UIColor.redColor forState:(UIControlStateNormal)];
    [openBtn setTitle:@"Push方式打开" forState:(UIControlStateNormal)];
    [openBtn addTarget:self action:@selector(openAction) forControlEvents:(UIControlEventTouchUpInside)];

    [openBtn sizeToFit];
    [self.view addSubview:openBtn];
    openBtn.center = CGPointMake(self.view.center.x, self.view.center.y - 50);
    
    UIButton *tabOpenBtn = [UIButton buttonWithType:(UIButtonTypeCustom)];
    tabOpenBtn.titleLabel.font = [UIFont systemFontOfSize:30];
    [tabOpenBtn setTitleColor:UIColor.redColor forState:(UIControlStateNormal)];
    [tabOpenBtn setTitle:@"Present Tabbar方式打开" forState:(UIControlStateNormal)];
    [tabOpenBtn addTarget:self action:@selector(tabOpenAction) forControlEvents:(UIControlEventTouchUpInside)];

    [tabOpenBtn sizeToFit];
    [self.view addSubview:tabOpenBtn];
    tabOpenBtn.center = CGPointMake(self.view.center.x, self.view.center.y + 50);
}
- (void)openAction{
    typeof(self) weak_self = self;
    [self requestUrlString:^(NSString *urlString) {
        /**根据列表页URL地址 自选打开方式
         URL的展示方式比较自由 例如present,push,safari打开,内部View视图局部展示,IBXSDKWebContentController工具等,下面只举例push的方式
         */
        IBXModeWebViewController *vc = [[IBXModeWebViewController alloc] initWithUrlString:urlString];
        [weak_self.navigationController pushViewController:vc animated:YES];
    }];
}
- (void)tabOpenAction{
    typeof(self) weak_self = self;
    [self requestUrlString:^(NSString *urlString) {
        /**根据列表页URL地址 自选打开方式
         URL的展示方式比较自由 例如present,push,safari打开,内部View视图局部展示,IBXSDKWebContentController工具等,下面只举例push的方式
         */
        IBXModeWebViewController *vc = [[IBXModeWebViewController alloc] initWithUrlString:urlString];
        UINavigationController *nav = [[UINavigationController alloc] initWithRootViewController:vc];
        nav.title = @"Tab方式";
        UITabBarController *tabVC = [[UITabBarController alloc] init];
        [tabVC addChildViewController:nav];
        tabVC.modalPresentationStyle = UIModalPresentationFullScreen;
        
        typeof(vc) weak_vc = vc;
        [weak_self presentViewController:tabVC animated:YES completion:^{
            weak_vc.navigationItem.leftBarButtonItem = [[UIBarButtonItem alloc] initWithTitle:@"<返回"
                                                                                        style:(UIBarButtonItemStyleDone)
                                                                                       target:weak_self
                                                                                       action:@selector(_dismiss)];
        }];
        

    }];
}
- (void)_dismiss{
    [self.presentedViewController dismissViewControllerAnimated:YES completion:nil];
}
- (void)requestUrlString:(void(^)(NSString *urlString))completedHandler{
    /**列表页URL地址有两种方式获取，
     1.通过后台直接获取
     2.通过SDK获取
     */
    __weak typeof(self) weak_self = self;

    UIAlertController *alert = [UIAlertController alertControllerWithTitle:@"主页类型" message:nil preferredStyle:(UIAlertControllerStyleActionSheet)];
    UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:@"取消" style:(UIAlertActionStyleCancel) handler:^(UIAlertAction * _Nonnull action) {
        
    }];
    UIAlertAction *defaultAction = [UIAlertAction actionWithTitle:@"默认" style:(UIAlertActionStyleDefault) handler:^(UIAlertAction * _Nonnull action) {
        // 通过SDK获取列表页URL地址
        [IBXSDK requestHomeUrl:^(NSString *urlString, NSError *error) {
            if (error != nil){
                [IBXSDKHelper alertError:error fromViewController:weak_self];
                return;
            }
            
            completedHandler(urlString);
        }];
    }];
    UIAlertAction *hrAction = [UIAlertAction actionWithTitle:@"高额" style:(UIAlertActionStyleDefault) handler:^(UIAlertAction * _Nonnull action) {
        // 通过SDK获取列表页URL地址
        [IBXSDK requestHighRewardHomeUrl:^(NSString *urlString, NSError *error) {
            if (error != nil){
                [IBXSDKHelper alertError:error fromViewController:weak_self];
                return;
            }
            
            completedHandler(urlString);

        }];
    }];
    [alert addAction:cancelAction];
    [alert addAction:defaultAction];
    [alert addAction:hrAction];
    [self presentViewController:alert animated:true completion:nil];

}

- (BOOL)prefersHomeIndicatorAutoHidden{
    return YES;
}

@end
