//
//  IBXDisplayModeTableViewController.m
//  IBXSDK_Example
//
//  Created by yeming on 2020/10/12.
//  Copyright © 2020 yemingxu. All rights reserved.
//

#import "IBXDisplayModeTableViewController.h"
#import "IBXSDKHelper.h"
#import "IBXModeSDKViewController.h"
#import "IBXModeH5ViewController.h"
#import "IBXModeCustomViewController.h"



@interface IBXDisplayModeTableViewController ()<UITableViewDelegate,UITableViewDataSource>
@property (nonatomic,strong) UITableView *rootTableView;
@end

@implementation IBXDisplayModeTableViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self loadUI];
    // Do any additional setup after loading the view.
}
#pragma mark - <UITableViewDelegate,UITableViewDataSource>
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView{
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section{
    return IBXDisplayMode_Custom + 1;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"CELL" forIndexPath:indexPath];
    cell.backgroundColor = UIColor.whiteColor;
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    IBXDisplayModes mode = indexPath.row;
    cell.textLabel.text = IBXDisplayModesDescribe(mode);
    cell.textLabel.textColor = UIColor.blackColor;
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    NSString *defaultTargetId = [NSUserDefaults.standardUserDefaults stringForKey:USERDEFAULT_TARGET_ID_KEY];
    if (!defaultTargetId.length){
        [IBXSDKHelper alertErrorMsg:@"TargetID不能为nil" fromViewController:self];
        return;
    }
    
    IBXDisplayModes mode = indexPath.row;
    switch (mode) {
        case IBXDisplayMode_SDK:{
            [IBXSDKConfig setupIsHiddenGoBackOfHome:NO];
            IBXModeSDKViewController *vc = [[IBXModeSDKViewController alloc] init];
            [self.navigationController pushViewController:vc animated:YES];
            break;
        }
        case IBXDisplayMode_H5:{
            [IBXSDKConfig setupIsHiddenGoBackOfHome:YES];
            IBXModeH5ViewController *vc = [[IBXModeH5ViewController alloc] init];
            [self.navigationController pushViewController:vc animated:YES];
            
            break;
        }
        case IBXDisplayMode_Custom:{
            IBXModeCustomViewController *vc = [[IBXModeCustomViewController alloc] init];
            [self.navigationController pushViewController:vc animated:YES];
            
            break;
        }
    }
}

#pragma mark - 设置TargetID
- (void)onTargetIDSet{
    UIAlertController *alert = [UIAlertController alertControllerWithTitle:@"设置TargetID" message:nil preferredStyle:(UIAlertControllerStyleAlert)];
    [alert addTextFieldWithConfigurationHandler:^(UITextField * _Nonnull textField) {
        textField.keyboardType = UIKeyboardTypeNumberPad;
        NSString *defaultTargetId = [NSUserDefaults.standardUserDefaults stringForKey:USERDEFAULT_TARGET_ID_KEY];
        if (defaultTargetId.length){
            textField.text = defaultTargetId;
        }
    }];
    UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:@"取消" style:(UIAlertActionStyleCancel) handler:^(UIAlertAction * _Nonnull action) {
        
    }];
    UIAlertAction *confirmAction = [UIAlertAction actionWithTitle:@"确定" style:(UIAlertActionStyleDestructive) handler:^(UIAlertAction * _Nonnull action) {
        NSString *targetID = alert.textFields.firstObject.text;
        if (targetID.length){
            [IBXSDKHelper sdkSetupWithTargetId:targetID];
            [NSUserDefaults.standardUserDefaults setObject:targetID forKey:USERDEFAULT_TARGET_ID_KEY];
            [NSUserDefaults.standardUserDefaults synchronize];
        }
    }];
    [alert addAction:cancelAction];
    [alert addAction:confirmAction];
    [self presentViewController:alert animated:true completion:nil];
}
#pragma mark - UI
- (void)loadUI{
    self.view.backgroundColor = UIColor.whiteColor;
    NSString *defaultTargetId = [NSUserDefaults.standardUserDefaults stringForKey:USERDEFAULT_TARGET_ID_KEY];
    if (defaultTargetId.length){
        [IBXSDKHelper sdkSetupWithTargetId:defaultTargetId];
    }
    
    UIBarButtonItem *setting = [[UIBarButtonItem alloc] initWithTitle:@"设置TargetID" style:(UIBarButtonItemStyleDone) target:self action:@selector(onTargetIDSet)];
    self.navigationItem.rightBarButtonItem = setting;
    
    [self.view addSubview:self.rootTableView];
}

#pragma mark - Lazys
- (UITableView *)rootTableView{
    if (!_rootTableView) {
        _rootTableView = [[UITableView alloc] initWithFrame:self.view.bounds style:(UITableViewStylePlain)];
        [_rootTableView registerClass:UITableViewCell.class forCellReuseIdentifier:@"CELL"];
        _rootTableView.backgroundColor = UIColor.whiteColor;
        _rootTableView.tableFooterView = [[UIView alloc] init];
        _rootTableView.delegate = self;
        _rootTableView.dataSource = self;
    }
    return _rootTableView;
}
- (BOOL)prefersHomeIndicatorAutoHidden{
    return YES;
}
@end
