//
//  IBXModeH5WebViewController.m
//  IBXSDK_Example
//
//  Created by yeming on 2020/10/12.
//  Copyright © 2020 yemingxu. All rights reserved.
//

#import "IBXModeWebViewController.h"
#import <WebKit/WebKit.h>
#import "IBXSDKHelper.h"
//#import "WXApi.h"


@interface WeakScriptMessageDelegate : NSObject<WKScriptMessageHandler>
@property (nonatomic, weak) id<WKScriptMessageHandler> scriptDelegate;
- (instancetype)initWithDelegate:(id<WKScriptMessageHandler>)scriptDelegate;
@end
 
@implementation WeakScriptMessageDelegate
- (instancetype)initWithDelegate:(id<WKScriptMessageHandler>)scriptDelegate {
    self = [super init];
    if (self) {
        _scriptDelegate = scriptDelegate;
    }
    return self;
}
- (void)userContentController:(WKUserContentController *)userContentController didReceiveScriptMessage:(WKScriptMessage *)message {
    [self.scriptDelegate userContentController:userContentController didReceiveScriptMessage:message];
}
@end
 


@interface IBXModeWebViewController ()<WKScriptMessageHandler>
@property (nonatomic,strong) WKWebView *wkWebView;
@end

@implementation IBXModeWebViewController
- (instancetype)initWithUrlString:(NSString *)urlString{
    self = [super init];
    if (self) {
        _urlString = urlString;
    }
    return self;
}
- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self loadUI];
    [self loadRequest];
}
- (void)viewDidDisappear:(BOOL)animated{
    [super viewDidDisappear:animated];

}

#pragma mark - WKScriptMessageHandler
- (void)userContentController:(WKUserContentController *)userContentController didReceiveScriptMessage:(WKScriptMessage *)message{
    if ( [message.name isEqualToString:@"ibx_openUrl"]){ // 打开外部地址
        // 解析出url
        NSDictionary *body = message.body;
        NSString *urlString = (NSString *)body[@"body"];
        
        // 获取到url,并进行完全自定义的处理
        // 例如直接通过Safari打开
        NSURL *theUrl = [NSURL URLWithString:urlString];
        if ([UIApplication.sharedApplication canOpenURL:theUrl]){
            [UIApplication.sharedApplication openURL:theUrl];
        }
        
    }else if ( [message.name isEqualToString:@"ibx_close"]){ // 关闭
        // 关闭
        [self.navigationController popViewControllerAnimated:YES];
        
    }else if ([message.name isEqualToString:@"ibx_openWXApplet"]){ // 打开微信小程序
//        if (![WXApi isWXAppInstalled]) { return; } // 微信未安装
        
//        NSDictionary<NSString *,NSObject *> *body = message.body;
//        NSString *appletID = (NSString *)body[@"id"];
//        NSString *appletPath = (NSString *)body[@"path"];
        // 拉起小程序
//        WXLaunchMiniProgramReq *launchMiniProgramReq = [WXLaunchMiniProgramReq object];
//        launchMiniProgramReq.userName = appletID;  //拉起的小程序的username-原始ID
//
//        // aunchMiniProgramReq.userName = @"gh_60b2f8c1a577";  //拉起的小程序的username-原始ID
//        launchMiniProgramReq.path = appletPath;    //拉起小程序页面的可带参路径，不填默认拉起小程序首页
//        launchMiniProgramReq.miniProgramType = WXMiniProgramTypeRelease; //拉起小程序的类型
//        [WXApi sendReq:launchMiniProgramReq];
    }
}

#pragma mark - 加载URL
- (void)loadRequest{
    NSURLRequest *req = [NSURLRequest requestWithURL:[NSURL URLWithString:self.urlString]];
    [self.wkWebView loadRequest:req];
}

#pragma mark - 加载UI
- (void)loadUI{
    self.view.backgroundColor = UIColor.whiteColor;
    CGRect frame = self.view.bounds;
    CGFloat navigationBarHeight = [IBXSDKHelper navigationBarHeight];
    self.wkWebView.frame = (CGRect){0,navigationBarHeight,frame.size.width,frame.size.height - navigationBarHeight};
    [self.view addSubview:self.wkWebView];
}

#pragma mark - Lazys
- (WKWebView *)wkWebView{
    if (!_wkWebView) {
        WKUserContentController *userContentController = [[WKUserContentController alloc] init];
        [userContentController addScriptMessageHandler:[[WeakScriptMessageDelegate alloc] initWithDelegate:self] name:@"ibx_openUrl"];
        [userContentController addScriptMessageHandler:[[WeakScriptMessageDelegate alloc] initWithDelegate:self] name:@"ibx_close"];
        [userContentController addScriptMessageHandler:[[WeakScriptMessageDelegate alloc] initWithDelegate:self] name:@"ibx_openWXApplet"];

        WKWebViewConfiguration *configuration = [[WKWebViewConfiguration alloc] init];
        configuration.userContentController = userContentController;
        
        WKWebView *wkWebView = [[WKWebView alloc] initWithFrame:UIScreen.mainScreen.bounds configuration:configuration];

        _wkWebView = wkWebView;
    }
    return _wkWebView;
}
- (BOOL)prefersHomeIndicatorAutoHidden{
    return YES;
}
- (void)dealloc{
    NSLog(@"%@ : %@",NSStringFromSelector(_cmd),self);
}
@end
