//
//  IBXSDKHelper.h
//  IBXDemo
//
//  Created by yeming on 2020/6/28.
//  Copyright © 2020 yeming. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <IBXSDK/IBXSDK.h>

static NSString *USERDEFAULT_TARGET_ID_KEY = @"target.id.key";
/**
 展示方式
 */
typedef NS_ENUM(NSUInteger,IBXDisplayModes){
    IBXDisplayMode_SDK = 0, // SDK接入
    IBXDisplayMode_H5, // H5接入
    IBXDisplayMode_Custom // 自定义列表页 + H5详情页
};

static inline NSString * IBXDisplayModesDescribe(IBXDisplayModes mode){
    switch (mode) {
        case IBXDisplayMode_SDK:
            return @"SDK接入";
        case IBXDisplayMode_H5:
            return @"H5接入";
        case IBXDisplayMode_Custom:
            return @"自定义列表页 + H5详情页";
    }
}

@interface IBXSDKHelper : NSObject<IBXSDKDelegate>
+ (instancetype)sharedInstance;

/**
 配置SDK
 */
+ (void)setupSDK;
+ (void)sdkSetupWithTargetId:(NSString *)targetId;

@end

@interface IBXSDKHelper(Utils)

+ (BOOL)isIphoneX;
+ (CGFloat)statusBarHeight;
+ (CGFloat)navigationBarHeight;

+ (void)alertError:(NSError *)error fromViewController:(UIViewController *)fromViewController;
+ (void)alertErrorMsg:(NSString *)msg fromViewController:(UIViewController *)fromViewController;

@end


