//
//  IBXSDKHelper.m
//  IBXDemo
//
//  Created by yeming on 2020/6/28.
//  Copyright © 2020 yeming. All rights reserved.
//

#import "IBXSDKHelper.h"


@implementation IBXSDKHelper
+ (instancetype)sharedInstance{
    
    static IBXSDKHelper *object;

    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        object = [[IBXSDKHelper alloc] init];
    });
    return object;
}
+ (void)setupSDK{
    NSString *targetId = @"xxx";
    [self sdkSetupWithTargetId:targetId];
}
+ (void)sdkSetupWithTargetId:(NSString *)targetId{

    NSString *appKey = @"xxx";
    NSString *secretKey = @"xxx";
    NSString *notifyUrl = nil;
        
    [IBXSDKConfig setupAppKey:appKey secretKey:secretKey targetId:targetId notifyUrl:notifyUrl];
}


#pragma mark - IBXSDKDelegate
- (void)ibx_didLoad{
    NSLog(@"%@",NSStringFromSelector(_cmd));
}

- (void)ibx_didLoadFail:(NSError *)error{
    NSLog(@"%@",NSStringFromSelector(_cmd));
    
}

- (void)ibx_didClose{
    NSLog(@"%@",NSStringFromSelector(_cmd));

}

- (void)ibx_didTriggerEvent:(IBXSDKEvent *)event{
    NSLog(@"%@",NSStringFromSelector(_cmd));

    switch (event.eventType) {
        case IBXSDKEventType_OPENURL:{
            // 打开外链
            break;
        }
            
            
        case IBXSDKEventType_OPENWXAPPLET:{
            // 打开微信小程序（IBXSDK内部不会集成微信SDK，需要自行集成）
            // 小程序参数获取
            NSString *appletID = event.appletID; // 小程序ID
            NSString *appletPath = event.appletPath; // 小程序子路径
            NSLog(@"[appletID : %@,appletPath : %@]",appletID,appletPath);
            // 以下参考微信SDK方式打开微信小程序
            /*
            if (![WXApi isWXAppInstalled]) { return; }
            // 拉起小程序
            WXLaunchMiniProgramReq *launchMiniProgramReq = [WXLaunchMiniProgramReq object];
            launchMiniProgramReq.userName = appletID;  //拉起的小程序的username-原始ID
            launchMiniProgramReq.path = appletPath;    //拉起小程序页面的可带参路径，不填默认拉起小程序首页
            launchMiniProgramReq.miniProgramType = WXMiniProgramTypeRelease; //拉起小程序的类型
            [WXApi sendReq:launchMiniProgramReq];
            */
            break;
        }
    }
    
}



@end
@implementation IBXSDKHelper(Utils)


+ (BOOL)isIphoneX{
    CGSize size = UIScreen.mainScreen.bounds.size;
    CGFloat width = size.width;
    CGFloat height = size.height;

    return (width == 375.0 && height == 812.0) || (width == 414.0 && height == 896.0);
}

+ (CGFloat)statusBarHeight{
    return self.isIphoneX ? 44.0 : 20.0;
}
+ (CGFloat)navigationBarHeight{
    return self.isIphoneX ? 88.0 : 64.0;
}



+ (void)alertError:(NSError *)error fromViewController:(UIViewController *)fromViewController{
    [self alertErrorMsg:error.description fromViewController:fromViewController];
}
+ (void)alertErrorMsg:(NSString *)msg fromViewController:(UIViewController *)fromViewController{
    UIAlertController *alert = [UIAlertController alertControllerWithTitle:nil message:msg preferredStyle:(UIAlertControllerStyleAlert)];
    UIAlertAction *action = [UIAlertAction actionWithTitle:@"知道了" style:(UIAlertActionStyleCancel) handler:^(UIAlertAction * _Nonnull action) {
        
    }];
    [alert addAction:action];
    [fromViewController presentViewController:alert animated:true completion:nil];
}
@end
