//
//  IBXModeSDKViewController.m
//  IBXSDK_Example
//
//  Created by yeming on 2020/10/12.
//  Copyright © 2020 yemingxu. All rights reserved.
//

#import "IBXModeSDKViewController.h"
#import <IBXSDK/IBXSDK.h>
//#import "WXApi.h"
#import "IBXSDKHelper.h"

@interface IBXModeSDKViewController ()<IBXSDKDelegate>

@end

@implementation IBXModeSDKViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor = UIColor.whiteColor;
    self.title = IBXDisplayModesDescribe(IBXDisplayMode_SDK);

    // Do any additional setup after loading the view.
    UIButton *openBtn = [UIButton buttonWithType:(UIButtonTypeCustom)];
    openBtn.titleLabel.font = [UIFont systemFontOfSize:30];
    [openBtn setTitleColor:UIColor.redColor forState:(UIControlStateNormal)];
    [openBtn setTitle:@"打开" forState:(UIControlStateNormal)];
    [openBtn addTarget:self action:@selector(openAction) forControlEvents:(UIControlEventTouchUpInside)];

    [openBtn sizeToFit];
    [self.view addSubview:openBtn];
    openBtn.center = self.view.center;
}
- (void)openAction{
    UIAlertController *alert = [UIAlertController alertControllerWithTitle:@"主页类型" message:nil preferredStyle:(UIAlertControllerStyleActionSheet)];
    UIAlertAction *calcelAction = [UIAlertAction actionWithTitle:@"取消" style:(UIAlertActionStyleCancel) handler:^(UIAlertAction * _Nonnull action) {
        
    }];
    UIAlertAction *defaultAction = [UIAlertAction actionWithTitle:@"默认" style:(UIAlertActionStyleDefault) handler:^(UIAlertAction * _Nonnull action) {
        [IBXSDK loadWithRootViewController:self delegate:self];
    }];
    UIAlertAction *hrAction = [UIAlertAction actionWithTitle:@"高额" style:(UIAlertActionStyleDefault) handler:^(UIAlertAction * _Nonnull action) {
        [IBXSDK loadWithHighRewardRootViewController:self delegate:self];
    }];
    [alert addAction:calcelAction];
    [alert addAction:defaultAction];
    [alert addAction:hrAction];
    [self presentViewController:alert animated:true completion:nil];

}

#pragma mark - Delegate
- (void)ibx_didLoad{
    NSLog(@"ibx_didLoad");
}

- (void)ibx_didLoadFail:(NSError *)error{
    NSLog(@"ibx_didLoadFail:%@",error);
    [IBXSDKHelper alertError:error fromViewController:self];
}

- (void)ibx_didClose{
    NSLog(@"ibx_didClose");
}

- (void)ibx_didTriggerEvent:(IBXSDKEvent *)event{
    NSLog(@"ibx_didTriggerEvent:%@",event);
    if (event.eventType != IBXSDKEventType_OPENWXAPPLET){
        return;
    }
    
//    if (![WXApi isWXAppInstalled]) { return; } // 微信未安装
//                        // 拉起小程序
//    WXLaunchMiniProgramReq *launchMiniProgramReq = [WXLaunchMiniProgramReq object];
//    launchMiniProgramReq.userName = event.appletID;  //拉起的小程序的username-原始ID
//
//    //                    launchMiniProgramReq.userName = @"gh_60b2f8c1a577";  //拉起的小程序的username-原始ID
//    launchMiniProgramReq.path = event.appletPath;    //拉起小程序页面的可带参路径，不填默认拉起小程序首页
//    launchMiniProgramReq.miniProgramType = WXMiniProgramTypeRelease; //拉起小程序的类型
//    [WXApi sendReq:launchMiniProgramReq];
}
- (BOOL)prefersHomeIndicatorAutoHidden{
    return YES;
}

@end
