//
//  ViewController.m
//  IBXDemo
//
//  Created by yeming on 2020/5/13.
//  Copyright © 2020 yeming. All rights reserved.
//

#import "ViewController.h"
#import <IBXSDK/IBXSDK.h>
#import "IBXSDKHelper.h"
#import "CustomViewController.h"

@interface ViewController ()

@end

@implementation ViewController


- (void)viewDidLoad{
    [super viewDidLoad];

    [self setupUI];
}

#pragma mark - Actions
- (void)presentAction{

    [IBXSDKHelper setupSDK]; // 防止targetID已修改，在必要时设置SDK

    [IBXSDK loadWithRootViewController:self delegate:IBXSDKHelper.sharedInstance];
}

- (void)pushAction{
    [IBXSDKHelper setupSDK]; // 防止targetID已修改，在必要时设置SDK

    CustomViewController *toVC = [[CustomViewController alloc] init];
    [self.navigationController pushViewController:toVC animated:true];
    
}

- (void)safariOpenAction{
    [IBXSDKHelper setupSDK]; // 防止targetID已修改，在必要时设置SDK

    [IBXSDK requestHomeUrl:^(NSString *urlString, NSError *error) {
        if (error){
            NSLog(@"%@",error);
            return;
        }
        
        NSURL *url = [NSURL URLWithString:urlString];
        if ([UIApplication.sharedApplication canOpenURL:url]){
            [UIApplication.sharedApplication openURL:url];
        }
    }];
}


#pragma mark - UI
- (void)setupUI{
    self.view.backgroundColor = UIColor.whiteColor;
    self.title = @"爱变现SDK DEMO";
    
    UIButton *presentBtn = [self customButtonWithTitle:@"present方式打开"];
    UIButton *pushBtn = [self customButtonWithTitle:@"push方式打开"];
    UIButton *safariBtn = [self customButtonWithTitle:@"safari方式打开"];
    
    [presentBtn addTarget:self action:@selector(presentAction) forControlEvents:(UIControlEventTouchUpInside)];
    [pushBtn addTarget:self action:@selector(pushAction) forControlEvents:(UIControlEventTouchUpInside)];
    [safariBtn addTarget:self action:@selector(safariOpenAction) forControlEvents:(UIControlEventTouchUpInside)];

    [self.view addSubview:presentBtn];
    [self.view addSubview:pushBtn];
    [self.view addSubview:safariBtn];
    
    CGPoint viewCenter = self.view.center;
    presentBtn.center = CGPointMake(viewCenter.x, viewCenter.y - 80);
    pushBtn.center = viewCenter;
    safariBtn.center = CGPointMake(viewCenter.x, viewCenter.y + 80);
}
- (UIButton *)customButtonWithTitle:(NSString *)title{
    UIButton *button = [UIButton buttonWithType:(UIButtonTypeCustom)];
    button.titleLabel.font = [UIFont systemFontOfSize:30];
    [button setTitleColor:UIColor.redColor forState:(UIControlStateNormal)];
    [button setTitle:title forState:(UIControlStateNormal)];
    [button sizeToFit];

    return button;
}
- (BOOL)prefersHomeIndicatorAutoHidden{
    return true;
}
@end
