//
//  IBXSDK.h
//  IBXSDK
//
//  Created by yeming on 2020/4/22.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import "IBXSDKConfig.h"
#import "IBXSDKEvent.h"



#pragma mark - IBXSDK代理
@protocol IBXSDKDelegate <NSObject>

/**
 加载成功
 */
- (void)ibx_didLoad;

/**
加载失败
*/
- (void)ibx_didLoadFail:(NSError *)error;

@optional;
/**
关闭
*/
- (void)ibx_didClose;

/**
 事件触发
 */
- (void)ibx_didTriggerEvent:(IBXSDKEvent *)event;

@end


#pragma mark - IBXSDK

@interface IBXSDK : NSObject

/** 加载主页
 */
+ (void)loadWithRootViewController:(UIViewController *)rootViewController delegate:(id<IBXSDKDelegate>)delegate;

/** 加载高额主页
 */
+ (void)loadWithHighRewardRootViewController:(UIViewController *)rootViewController delegate:(id<IBXSDKDelegate>)delegate;


/** 请求主页地址地址
 */
+ (void)requestHomeUrl:(void(^)(NSString *url, NSError *error))callback;

/** 请求高额主页地址地址
 */
+ (void)requestHighRewardHomeUrl:(void(^)(NSString *url, NSError *error))callback;
@end

