//
//  IBXSDKEvent.h
//  IBXSDK
//
//  Created by yeming on 2020/6/19.
//

#import <Foundation/Foundation.h>
#pragma mark - 事件
typedef NS_ENUM(NSUInteger, IBXSDKEventType){
    IBXSDKEventType_OPENURL = 0, // 打开链接
    IBXSDKEventType_OPENWXAPPLET,// 打开微信小程序
};

@interface IBXSDKEvent : NSObject
@property (nonatomic,assign,readonly) IBXSDKEventType eventType;
@property (nonatomic,copy,readonly) NSString *urlString;
@property (nonatomic,copy,readonly) NSString *appletID; // 小程序ID
@property (nonatomic,copy,readonly) NSString *appletPath; // 小程序path
- (instancetype)init UNAVAILABLE_ATTRIBUTE;
- (instancetype)initWithType:(IBXSDKEventType)eventType urlString:(NSString *)urlString;
- (instancetype)initWithType:(IBXSDKEventType)eventType appletID:(NSString *)appletID appletPath:(NSString *)appletPath;

@end
