//
//  IBXSDKWebContentController.h
//  IBXSDK
//
//  Created by yeming on 2020/6/15.
//

#import <UIKit/UIKit.h>
#import "IBXSDK.h"

@protocol IBXSDKWebContentDelegate <NSObject>

@optional
/**网页标题*/
- (void)ibxsdk_webContentDidUpdateWebTitle:(NSString *)webtitle;

/**网页加载进度*/
- (void)ibxsdk_webContentDidUpdateWebProgress:(double)webprogress;

@end

@interface IBXSDKWebContentController : UIViewController


@property (nonatomic,weak) id<IBXSDKDelegate> delegate;
@property (nonatomic,weak) id<IBXSDKWebContentDelegate> contentDelegate;
@property (nonatomic,assign,readonly) double webprogress;
@property (nonatomic,copy,readonly) NSString *_webtitle;

- (instancetype)initWithUrlString:(NSString *)urlString;

- (void)resetUrlString:(NSString *)urlString;
- (void)reload;
@end


