

## BXSDK接入说明（2.0.1）

### 1. 接⼊准备

接⼊SDK前 请您按照要求在爱变现平台申请appKey、secretKey。

iOS14.5升级须知：

​	1、Info.plist 添加如下

```objective-c
<key>NSUserTrackingUsageDescription</key>
	<string>获取IDFA标记权限向您提供更优质、安全的个性化服务及内容；开启后，您也可以前往系统“设置-隐私 ”中随时关闭。</string>
```

​	2、IBXSDK.framework 用新版 复制替换 旧版

### 2.接⼊SDK

##### 2.1 将IBXSDK.framework和IBXSDK.bundle拖入工程（SDK不支持模拟器，最低支持9.0以上）

###### 注意:准备从1.0.0升级的用户，需要先从工程内删除1.0.1的IBXSDK.framework。再将IBXSDK.framework和IBXSDK.bundle拖入工程



2.1.1 配置Info.plist

添加http网络访问权限：

```objective-c
	<key>NSAppTransportSecurity</key>
	<dict>
		<key>NSAllowsArbitraryLoads</key>
		<true/>
	</dict>
```

添加相册访问权限(高额模式需要从相册中选择图片)：

```objective-c
	<key>NSCameraUsageDescription</key>
	<string>相机功能</string>
```

2.2.2 配置Target:

打开Target > Build Settings 并搜索OTHER_LDFLAGS

在Other Linker Flags选项中添加

```
$(inherited)
-ObjC
-all_load
```



##### 2.2 SDK配置

```objective-c
#import <IBXSDK/IBXSDK.h>

[IBXSDKConfig setupAppKey:@"xxx" 
 secretKey:@"xxx" targetId:@"13457" notifyUrl:@"http://www.xxxx.com/xxxx/xxxx.php"];
```

参数说明：appKey、secretKey由爱变现平台申请生成。targetId为用户ID、notifyUrl为奖励发放回调地址(<font color='red'>没有可以传nil</font>)。

<font color='red'> 注意：demo中不默认提供演示的appKey、secretKey。请自行修改。 </font>

##### 

```objective-c
#import <IBXSDK/IBXSDK.h>

/**
配置首页返回键 - 默认显示返回键
YES: 隐藏
NO: 显示
*/
[IBXSDKConfig setupIsHiddenGoBackOfHome:YES];

```

### 3. 接口使用

##### 加载回调如下delegate方法

```objective-c
/**
 加载成功
 */
- (void)ibx_didLoad;

/**
加载失败
*/
- (void)ibx_didLoadFail:(NSError *)error;

/**
关闭
*/
- (void)ibx_didClose;

/**
 事件触发
 */
- (void)ibx_didTriggerEvent:(IBXSDKEvent *)event;

```



##### IBXSDKEvent说明：

###### 事件类型:

```objective-c
@property (nonatomic,assign,readonly) IBXSDKEventType eventType; // 事件类型
typedef NS_ENUM(NSUInteger, IBXSDKEventType){
    IBXSDKEventType_OPENURL = 0, // 打开外部链接
    IBXSDKEventType_OPENWXAPPLET,// 打开微信小程序
};
```

###### 事件参数获取:

```objective-c
// IBXSDKEventType_OPENURL 参数获取
@property (nonatomic,copy,readonly) NSString *urlString; // 外链url

// IBXSDKEventType_OPENWXAPPLET 参数获取
@property (nonatomic,copy,readonly) NSString *appletID; // 小程序ID
@property (nonatomic,copy,readonly) NSString *appletPath; // 小程序path
```

###### 小程序特别说明: IBXSDK内部未集成微信SDK,需要自行集成。IBXSDK会在回调方法- (void)ibx_didTriggerEvent:(IBXSDKEvent *)event;中反馈小程序的参数

```objective-c

- (void)ibx_didTriggerEvent:(IBXSDKEvent *)event{
    NSLog(@"%@",NSStringFromSelector(_cmd));

    switch (event.eventType) {
        case IBXSDKEventType_OPENURL:{
            // 打开外链
            break;
        }
            
            
        case IBXSDKEventType_OPENWXAPPLET:{
            // 打开微信小程序（IBXSDK内部不会集成微信SDK，需要自行集成）
            // 小程序参数获取
            NSString *appletID = event.appletID; // 小程序ID
            NSString *appletPath = event.appletPath; // 小程序子路径

            // 以下参考微信SDK方式打开微信小程序
            /*
            if (![WXApi isWXAppInstalled]) { return; }
            // 拉起小程序
            WXLaunchMiniProgramReq *launchMiniProgramReq = [WXLaunchMiniProgramReq object];
            launchMiniProgramReq.userName = appletID;  //拉起的小程序的username-原始ID
            launchMiniProgramReq.path = appletPath;    //拉起小程序页面的可带参路径，不填默认拉起小程序首页
            launchMiniProgramReq.miniProgramType = WXMiniProgramTypeRelease; //拉起小程序的类型
            [WXApi sendReq:launchMiniProgramReq];
            */
            break;
        }
    }
    
}
```



### 4.接入方式

接入方式灵活，一般分为三种：1.SDK接入，2.H5接入，3.主页列表自定义+详情页

功能模式分两种：默认、高额

##### 1.SDK接入：

说明：通过推出全屏新页面的方式，展示爱变现页面。

功能模式-默认：

```objective-c
[IBXSDK loadWithRootViewController:self delegate:self];
```

功能模式-高额：

```objective-c
[IBXSDK loadWithHighRewardRootViewController:self delegate:self];
```



##### 2.H5接入：

说明：通过在屏幕上自定义一块区域，并在此区域展示爱变现页面。用户可以自定义头部/底部，仅在内容上展示爱变现页面

分三步进行。一、通过SDK请求url地址，二、通过WKWebView加载url地址，三、处理HTML回调

一、通过SDK请求url地址:

​	功能模式-默认：

```objective-c
        [IBXSDK requestHomeUrl:^(NSString *urlString, NSError *error) {
            if (error != nil){
                [IBXSDKHelper alertError:error fromViewController:weak_self];
                return;
            }
            // 已接收urlString
        }];
```

​	功能模式-高额：

```objective-c
        [IBXSDK requestHighRewardHomeUrl:^(NSString *urlString, NSError *error) {
            if (error != nil){
                [IBXSDKHelper alertError:error fromViewController:weak_self];
                return;
            }
            
            // 已接收urlString
        }];
```

二、通过WKWebView加载url地址：

```objective-c
// 导入头文件
#import <IBXSDK/IBXSDK.h>
#import <IBXSDK/IBXSDKWebContentController.h>

// 加载childViewController 并设置代理
- (void)setupUI{
    if (_ibx_contentController){
        return;
    }
WKUserContentController *userContentController = [[WKUserContentController alloc] init];
[userContentController addScriptMessageHandler:self name:@"ibx_close"];
  [userContentController addScriptMessageHandler:self name:@"ibx_openUrl"];

WKWebViewConfiguration *configuration = [[WKWebViewConfiguration alloc] init];
configuration.userContentController = userContentController;
WKWebView *wkWebView = [[WKWebView alloc] initWithFrame:UIScreen.mainScreen.bounds configuration:configuration];
  // 加载第一步获取的urlString
      NSURLRequest *req = [NSURLRequest requestWithURL:[NSURL URLWithString:self.urlString]];
    [self.wkWebView loadRequest:req];
}

```

三、处理HTML回调：

```objective-c

// WKScriptMessageHandler
- (void)userContentController:(WKUserContentController *)userContentController didReceiveScriptMessage:(WKScriptMessage *)message{
  if ( [message.name isEqualToString:@"ibx_openUrl"]){ // 打开外部地址
        // 解析出url
        NSDictionary *body = message.body;
        NSString *urlString = (NSString *)body[@"body"];
        
        // 获取到url,并进行完全自定义的处理
        // 例如直接通过Safari打开
        NSURL *theUrl = [NSURL URLWithString:urlString];
        if ([UIApplication.sharedApplication canOpenURL:theUrl]){
            [UIApplication.sharedApplication openURL:theUrl];
        }
        
    }else if ( [message.name isEqualToString:@"ibx_close"]){

 // 在此处关闭
 [self dismissViewControllerAnimated:YES completion:nil];
}

```



##### 3.主页列表自定义+详情页：

说明：自定义主页列表

分两部步进行。1.请求首页数据并自定义UI，2.点击UI时进入游戏详情

​	1.请求首页数据并自定义UI: 

​			1).请求token 

​				接口：https://api.aibianxian.net/igame/api/v1.2/cplApi/access，

​				参考demo中的<font color='red'>IBXModeCustomTokenUtil.m</font>

​			2).请求游戏列表

​				接口：https://api.aibianxian.net/igame/api/v1.0/cplApi/listGameByTargetId

​				参考demo中的<font color='red'>IBXModeCustomViewModel.m</font>

​			3).自定义UI

> http://www.aibianxian.net/igame-guide/api-list.html#ios

​	注意：完整接口文档地址<font color='red'>http://www.aibianxian.net/igame-guide/api-list.html#ios</font>

​	2.点击UI时进入游戏详情：

​		一、打开详情页url地址

​		二、处理HTML回调。

​		请参考接入方式2中的二、三步

