package com.aiyingli.imoney;

import android.app.Activity;
import android.app.Application;
import android.os.Build;
import android.os.Bundle;
import android.view.KeyEvent;

import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentTransaction;

import com.aiyingli.ibxmodule.IBXFragment;
import com.aiyingli.ibxmodule.IBXListener;
import com.aiyingli.ibxmodule.IBXSdk;
import com.aiyingli.ibxmodule.LogUtil;
import com.ayl.deviceinfo.util.IMEIUtil;
import com.ayl.deviceinfo.util.OAIDHelper;

/**
 * Android10及以上如果获取不到 oaid 请弹框提示，不能显示爱变现页面（没有oaid，用户玩游戏也没有收益）
 */
public class Button7Activity extends FragmentActivity {
    
    IBXFragment instance;
    
    private String mDeviceInfo = "test";
    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        
        setContentView(R.layout.activity_button7);
        
        // 获取 设备唯一标识
        getDeviceId();
        //TODO 使用Fragment加载URL，需要自行提前获取设备信息,并初始化
        IBXSdk.getInstance().init(getApplication(),Main2Activity.appKey,Main2Activity.targetId,mDeviceInfo,Main2Activity.secret);
        IBXSdk.getInstance().post(new IBXListener() {
            @Override
            public void success(final String url) {
                LogUtil.info("request url =",url);
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        instance = IBXFragment.getInstance(url);
                        FragmentTransaction fragmentTransaction = getSupportFragmentManager().beginTransaction();
                        fragmentTransaction.add(R.id.flFragment, instance);
                        fragmentTransaction.commitAllowingStateLoss();
                    }
                });
            }
    
            @Override
            public void failed(Object o) {
        
            }
        });
        
    }
    
    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (instance != null && keyCode == KeyEvent.KEYCODE_BACK) {
            instance.onKeyDown(keyCode,event);
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }
    
    private void getDeviceId() {
        final Application application = getApplication();
        
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.Q) {
            mDeviceInfo = IMEIUtil.getIMEI(application);
        } else {
            try {
                new OAIDHelper(getApplicationContext(),(isSupport, oaid, aaid, vaid) -> {
                    if (isSupport) {
                        mDeviceInfo = oaid;
                    }
                }).getDeviceIds(this);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}
