package com.aiyingli.imoney;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;


import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.aiyingli.ibxmodule.IBXBatteryReceiver;
import com.aiyingli.ibxmodule.LogUtil;
import com.ayl.deviceinfo.ActivityLifeCycle;
import com.ayl.deviceinfo.BaseInfo;
import com.ayl.deviceinfo.BatteryInfo;
import com.ayl.deviceinfo.NetInfo;
import com.ayl.deviceinfo.util.AllInfo;
import com.ayl.deviceinfo.util.NetWorkSpeedUtils;
import com.ayl.deviceinfo.util.PreferenceUtil;
import com.bumptech.glide.Glide;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

import static com.aiyingli.imoney.Main2Activity.mDeviceInfo;


/****
 * 对于cpa接口
 * 1.需要先获取到token,放入 header 中  token=***  getToken()方法为获取token 的示例
 * 2.请求的通用模板为
 * {"base":{},"params":{},"oaid":"nnnn"}
 * 其中
 * -base 为 getBase() 方法获取的一些设备信息，获取 base 需要先 调用 initReceiver()，initAllInfo() 这两个方法，
 * 请提前获取相关权限(设备信息/蓝牙/wifi等)
 * -params中为接口需要的参数，请参考 queryList() / robTask()
 * -oaid 为设备的OAID,没有的话传空串
 * 3.获取 base 前需要先发送 LUA_CINFO 接口(Get) 获取到 content
 * 4.在接口请求成功时，在返回的json中，code=200代表数据请求成功； =-1时，错误信息请查看 message ；=其他 错误信息请查看 msg
 * 5.在抢任务时，如果接口返回 code=102 代表已存在任务，需要提示用户是否放弃之前的任务。当用户确认时，先发送放弃任务接口，再发送抢任务接口，code=200后进入详情页
 * 6.跳转详情页时，需要传入三个参数 taskId taskType token
 * 7.除 LUA_CINFO 接口为 Get 其余均为 Post 具体调用请参考 queryList() 方法
 * 8.如有其他疑问，请在对接群沟通
 */
public class CpaAsoListActivity extends Activity {
    public static final String TAG = "CpaAsoListActivity";

    public static final String TOKEN_URL            = "https://api.aibianxian.net/igame/api/v1.0/cplApi/access";
    private static final String LUA_CINFO           = "https://api.aibianxian.net/igame/api/v1.0/cpa/getLuaCInfo";
    private static final String LIST_URL            = "https://api.aibianxian.net/igame/api/v1.0/cpa/getList";
    private static final String ROB_TASK_URL        = "https://api.aibianxian.net/igame/api/v1.0/cpa/robTask";
    private static final String GIVE_UP_TASK_URL    = "https://api.aibianxian.net/igame/api/v1.0/cpa/giveUpTask";
    private static final String DETAIL_URL          = "https://api.aibianxian.net/igameh5/#/cpadetail?taskId=%s&taskType=%s&token=%s&nextClose=1&ibxsdk=android";

    RecyclerView recyclerView;
    ProgressBar pbProgress;

    private String token = "";
    private String content = ""; // LUA_CINFO 接口获得

    @Override
    protected void onCreate( Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_cpa_aso);
    
        Log.e(TAG,"----------" + mDeviceInfo);

        getToken();


        initReceiver();
        initAllInfo();


        recyclerView = findViewById(R.id.rvData);

        pbProgress = findViewById(R.id.pbProgress);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));

        recyclerView.postDelayed(new Runnable() { // TODO 延迟是因为需要收集一些变化后的数据，可以提前初始化，这样就不用延迟了
            @Override
            public void run() {
                if (pbProgress != null) {
                    pbProgress.setVisibility(View.GONE);
                }
                queryList();
            }
        },5 * 1000);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }

    /***
     * 跳转详情页
     * @param map
     */
    private void goDetail(Map<String,String> map) {

        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                String url = String.format(DETAIL_URL,map.get("taskId"),map.get("taskType"),token);
                Log.e(TAG, "detail url = " + url);
                ListH5FragmentActivity.start(CpaAsoListActivity.this, url);
            }
        });
    }

    /***
     * 初始化信息
     */
    private void initAllInfo() {

       getApplication().registerActivityLifecycleCallbacks(new ActivityLifeCycle());
        NetWorkSpeedUtils netWorkSpeedUtils = new NetWorkSpeedUtils(getApplicationContext());
        netWorkSpeedUtils.startShowNetSpeed();

    }

    /**
     * 初始化电池变化的广播接收者
     */
    private void initReceiver() {
        IntentFilter filter = new IntentFilter();
        filter.addAction(Intent.ACTION_BATTERY_CHANGED);
        registerReceiver(new IBXBatteryReceiver(), filter);
    }


    /***
     * 获取 base 数据
     * @return
     */
    private JSONObject getBase() {
        try {
            AllInfo.InfoBuilder infoBuilder = (new AllInfo.InfoBuilder(this).addClientId(content));
            List<BaseInfo> allInfo = infoBuilder.getAllInfo();
            Iterator var4 = allInfo.iterator();

            while(var4.hasNext()) {
                BaseInfo info = (BaseInfo)var4.next();
                if (info instanceof NetInfo) {
                    info.getMap().put("downloadSpeed", (float)NetWorkSpeedUtils.getMaxSpeed() * 1.0F / 1024.0F);
                }
            }

            BatteryInfo batteryInfo = new BatteryInfo();
            batteryInfo.buildParams();
            allInfo.add(batteryInfo);
            infoBuilder.addInfo(batteryInfo);
            Map<String, Object> map = new HashMap();
            Iterator var6 = allInfo.iterator();

            while(var6.hasNext()) {
                BaseInfo baseInfo = (BaseInfo)var6.next();
                map.putAll(baseInfo.getMap());
            }
    
            JSONObject jsonObject = new JSONObject(map);
            PreferenceUtil.putValue(this, "base", "base", jsonObject.toString());
            return jsonObject;
        } catch (Exception var8) {
            var8.printStackTrace();
            return new JSONObject();
        }
    }

    /**
     * 查询列表
     */
    private void queryList() {

        OkHttpClient.Builder builder = new OkHttpClient.Builder()
                .connectTimeout(5, TimeUnit.SECONDS) // 数值自定义
                .readTimeout(5, TimeUnit.SECONDS)
                .writeTimeout(5, TimeUnit.SECONDS);
        OkHttpClient okHttpClient = builder.build();


        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("oaid",mDeviceInfo);//todo 自己获取 OAID
            jsonObject.put("base",getBase());

            JSONObject params = new JSONObject();
            params.put("page",1);
            params.put("limit",10);
            jsonObject.put("params",params);

            RequestBody requestBody = RequestBody.create(MediaType.parse("application/json; charset=utf-8"),jsonObject.toString());

            Request okRequest = new Request.Builder()
                    .url(LIST_URL)
                    .addHeader("token",token) // todo
                    .post(requestBody)
                    .build();

            Call newCall = okHttpClient.newCall(okRequest);
            newCall.enqueue(new Callback() {

                @Override
                public void onFailure(Call call, IOException e) {
                    Log.e(TAG, e.getMessage());

                }

                @Override
                public void onResponse(Call call, Response response)   {

                    try {
                        String string = response.body().string();
                        Log.e(TAG, "cpa list = " + string);
                        JSONObject json = new JSONObject(string);
                        int code = json.getInt("code");
                        if (code == 200) { // 接口成功
                            JSONArray data = json.getJSONArray("data");
                            List<Map<String,String>> list = new ArrayList<>(data.length());
                            for (int i = 0; i < data.length(); i++) {
                                JSONObject obj = (JSONObject) data.get(i);
                                Map<String,String> map = new HashMap<>(3);
                                map.put("icon",obj.getString("appIcon"));
                                map.put("name",obj.getString("appName"));
                                map.put("price",obj.getString("price"));
                                map.put("orderId",obj.getString("orderId"));
                                map.put("taskType",obj.getString("taskType"));
                                list.add(map);
                            }
                            runOnUiThread(new Runnable() {
                                @Override
                                public void run() {
                                    Adapter adapter = new Adapter(list,CpaAsoListActivity.this);
                                    recyclerView.setAdapter(adapter);
                                }
                            });

                        } else if (code == -1) {
                            showToast(json.optString("message"));
                        } else {
                            showToast(json.optString("msg"));
                        }

                    } catch (IOException | JSONException e) {
                        e.printStackTrace();
                    }
                }
            });


        } catch (JSONException e) {
            e.printStackTrace();
        }
    }
    /**
     * 插叙列表
     */
    private void queryLuaCInfo (String token) {

        OkHttpClient.Builder builder = new OkHttpClient.Builder()
                .connectTimeout(5, TimeUnit.SECONDS) // 数值自定义
                .readTimeout(5, TimeUnit.SECONDS)
                .writeTimeout(5, TimeUnit.SECONDS);
        OkHttpClient okHttpClient = builder.build();
        Request okRequest = new Request.Builder()
                .url(LUA_CINFO)
                .addHeader("token",token)
                .get()
                .build();

        Call newCall = okHttpClient.newCall(okRequest);
        newCall.enqueue(new Callback() {

            @Override
            public void onFailure(Call call, IOException e) {
                Log.e("CpaAsoListActivity-TAG",""+e.getMessage());

            }

            @Override
            public void onResponse(Call call, Response response)   {
                try {
                    String string = response.body().string();
                    JSONObject json = new JSONObject(string);
                    int code = json.getInt("code");
                    if (code == 200) { // 接口成功
                        JSONObject data = json.getJSONObject("data");
                        content = data.getString("content");
                    }

                } catch (IOException | JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    /**获取 token 需要放到 header 里
     */
    private void getToken() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder()
                .connectTimeout(5, TimeUnit.SECONDS) // 数值自定义
                .readTimeout(5, TimeUnit.SECONDS)
                .writeTimeout(5, TimeUnit.SECONDS);

        OkHttpClient okHttpClient = builder.build();

        String device = "android";

        FormBody formBody = new FormBody
                .Builder()
                .add("app_key", Main2Activity.appKey)
                .add("device", device)
                .add("device_info", mDeviceInfo)
                .add("target_id", Main2Activity.targetId)
                .build();

        Request request = new Request
                .Builder()
                .post(formBody)//Post请求的参数传递
                .url(TOKEN_URL)
                .build();

        Call call = okHttpClient.newCall(request);
        call.enqueue(new Callback() {
            @Override
            public void onFailure(Call call, IOException e) {
                Log.d(TAG, " failed ");
            }

            @Override
            public void onResponse(Call call, Response response) throws IOException {
                String string = response.body().string();
                Log.d(TAG, " onResponse token=" + string);
                try {

                    //数据格式 {"code":"200","data":{"token":"*****"}}

                    JSONObject jsonObject = new JSONObject(string);
                    JSONObject dataObj = jsonObject.getJSONObject("data");
                    token = dataObj.getString("token");
                    queryLuaCInfo(token);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }


    /**
     * 抢任务
     * @param mapClicked 点击的条目
     */
    public void robTask(Map<String, String> mapClicked) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder()
                .connectTimeout(5, TimeUnit.SECONDS) // 数值自定义
                .readTimeout(5, TimeUnit.SECONDS)
                .writeTimeout(5, TimeUnit.SECONDS);
        OkHttpClient okHttpClient = builder.build();


        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("oaid",mDeviceInfo);//todo 自己获取 OAID
            jsonObject.put("base",getBase());

            JSONObject params = new JSONObject();
            params.put("orderId",mapClicked.get("orderId"));
            params.put("taskType",mapClicked.get("taskType"));
            jsonObject.put("params",params);

            RequestBody requestBody = RequestBody.create(MediaType.parse("application/json; charset=utf-8"),jsonObject.toString());

            Request okRequest = new Request.Builder()
                    .url(ROB_TASK_URL)
                    .addHeader("token",token) // todo
                    .post(requestBody)
                    .build();

            Call newCall = okHttpClient.newCall(okRequest);
            newCall.enqueue(new Callback() {

                @Override
                public void onFailure(Call call, IOException e) {


                }

                @Override
                public void onResponse(Call call, Response response)   {
                    try {
                        String string = response.body().string();
                        Log.e(TAG, "rob task = " + string);
                        JSONObject json = new JSONObject(string);
                        int code = json.getInt("code");
                        if (code == 200) { // 接口成功
                            JSONObject obj = json.getJSONObject("data");
                            Map<String,String> mapDoing = new HashMap<>(3);

//                            mapDoing.put("icon",obj.getString("appIcon"));
                            mapDoing.put("name",obj.optString("appName"));
                            mapDoing.put("price",obj.optString("price"));
                            mapDoing.put("taskId",obj.optString("taskId"));
                            mapDoing.put("orderId",obj.optString("orderId"));
                            mapDoing.put("taskType",obj.optString("taskType"));

                            goDetail(mapDoing);

                        } if (code == 102) { //TODO 已存在任务 需要弹框让用户选择是否放弃
                            String msg = json.getString("msg");

                            JSONObject obj = json.getJSONObject("data");
                            Map<String,String> mapDoing = new HashMap<>(3);

                            mapDoing.put("icon",obj.optString("appIcon"));
                            mapDoing.put("name",obj.optString("appName"));
                            mapDoing.put("price",obj.optString("price"));
                            mapDoing.put("taskId",obj.optString("taskId"));
                            mapDoing.put("orderId",obj.optString("orderId"));
                            mapDoing.put("taskType",obj.optString("taskType"));

                            runOnUiThread(new Runnable() {
                                @Override
                                public void run() {
                                    AlertDialog.Builder builder = new AlertDialog.Builder(CpaAsoListActivity.this);
                                    builder.setMessage(msg);
                                    builder.setTitle("温馨提示");
                                    builder.setNegativeButton("取消", new DialogInterface.OnClickListener() {
                                        @Override
                                        public void onClick(DialogInterface dialog, int which) {
                                            dialog.dismiss();
                                        }
                                    });
                                    builder.setPositiveButton("放弃", new DialogInterface.OnClickListener() {
                                        @Override
                                        public void onClick(DialogInterface dialog, int which) { //TODO  先发放弃接口，再发送抢任务接口，之后进入详情页
                                            giveUpTask(mapClicked,mapDoing);
                                            dialog.dismiss();
                                        }
                                    });
                                    builder.show();
                                }
                            });
                        }

                    } catch (IOException | JSONException e) {
                        e.printStackTrace();
                    }
                }
            });


        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    /***
     * 放弃之前的任务，抢点击的任务
     * @param mapClicked
     * @param mapDoing
     */
    public void giveUpTask(Map<String, String> mapClicked, Map<String, String> mapDoing) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder()
                .connectTimeout(5, TimeUnit.SECONDS) // 数值自定义
                .readTimeout(5, TimeUnit.SECONDS)
                .writeTimeout(5, TimeUnit.SECONDS);
        OkHttpClient okHttpClient = builder.build();


        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("oaid",mDeviceInfo);//todo 自己获取 OAID
            jsonObject.put("base",getBase());

            JSONObject params = new JSONObject();
            params.put("taskId",mapDoing.get("taskId"));
            params.put("taskType",mapDoing.get("taskType"));
            jsonObject.put("params",params);

            RequestBody requestBody = RequestBody.create(MediaType.parse("application/json; charset=utf-8"),jsonObject.toString());

            Request okRequest = new Request.Builder()
                    .url(GIVE_UP_TASK_URL)
                    .addHeader("token",token) // todo
                    .post(requestBody)
                    .build();

            Call newCall = okHttpClient.newCall(okRequest);
            newCall.enqueue(new Callback() {

                @Override
                public void onFailure(Call call, IOException e) {


                }

                @Override
                public void onResponse(Call call, Response response)   {
                    try {
                        String string = response.body().string();
                        Log.e(TAG, "give_up task = " + string);
                        JSONObject json = new JSONObject(string);
                        int code = json.getInt("code");
                        if (code == 200) { // 接口成功
                            robTask(mapClicked);
                        }

                    } catch (IOException | JSONException e) {
                        e.printStackTrace();
                    }
                }
            });


        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void showToast(String msg) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Toast.makeText(getApplicationContext(),msg,Toast.LENGTH_SHORT).show();
            }
        });
        
    }
}

/***
 * 列表的适配器
 */
class Adapter extends RecyclerView.Adapter<Adapter.Holder> {
    class Holder extends RecyclerView.ViewHolder {

        private final ImageView ivLogo;
        private final TextView tvName;
        private final TextView tvPrice;
        public Holder( View itemView) {
            super(itemView);


            ivLogo = (ImageView) itemView.findViewById(R.id.ivLogo);
            tvName = (TextView)  itemView.findViewById(R.id.tvName);
            tvPrice = (TextView) itemView.findViewById(R.id.tvPrice);
        }
    }

    private final List<Map<String,String>> list;
    private final CpaAsoListActivity activity;

    public Adapter(List<Map<String, String>> list, CpaAsoListActivity activity) {
        this.list = list;
        this.activity = activity;
    }


    @Override
    public Holder onCreateViewHolder( ViewGroup parent, int viewType) {
        return new Holder(activity.getLayoutInflater().inflate(R.layout.item_data,parent,false));
    }

    @Override
    public void onBindViewHolder( Holder holder, int position) {
        Map<String,String> map = list.get(position);
        Glide.with(holder.ivLogo).load(map.get("icon")).into(holder.ivLogo);

        holder.tvName.setText(map.get("name"));
        holder.tvPrice.setText(map.get("price")+"元");

        holder.itemView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                activity.robTask(map);
            }
        });
    }

    @Override
    public int getItemCount() {
        return list.size();
    }






}
