package com.aiyingli.imoney;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.webkit.WebView;
import android.webkit.WebViewClient;



import com.aiyingli.ibxmodule.IBXListener;
import com.aiyingli.ibxmodule.IBXSdk;
import com.aiyingli.ibxmodule.MyJavascript;
import com.aiyingli.ibxmodule.service.DownFileService;

import static com.aiyingli.imoney.Main2Activity.appKey;
import static com.aiyingli.imoney.Main2Activity.secret;
import static com.aiyingli.imoney.Main2Activity.targetId;

public class CustomActivity extends Activity {


    WebView webView;
    CustomJavaScript customJavaScript;

    @SuppressLint("SetJavaScriptEnabled")
    @Override
    protected void onCreate( Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        webView = findViewById(R.id.webView);

        customJavaScript = new CustomJavaScript(webView, this);
        webView.addJavascriptInterface(customJavaScript, MyJavascript.NAME_SPACE);
        webView.getSettings().setJavaScriptEnabled(true);
        webView.getSettings().setDomStorageEnabled(true);
        webView.setWebViewClient(new WebViewClient());


        IBXSdk.getInstance()
                .init(getApplication(),appKey,targetId,Main2Activity.mDeviceInfo,secret,"1");

        IBXSdk.getInstance().showLog(true).setDebug(true);
        IBXSdk.getInstance().post(new IBXListener() {
            @Override
            public void success(final String url) {
                Log.e("  url  ", "url " + url);
//
                runOnUiThread(() -> webView.loadUrl(url));
            }

            @Override
            public void failed(Object obj) {

            }
        });
    }

    @Override
    protected void onResume() {
        super.onResume();
        if (customJavaScript != null) {
            customJavaScript.backAppUsageData();
        }
    }

    @Override
    protected void onDestroy() {
        DownFileService.finishService(this);
        if (customJavaScript != null) {
            customJavaScript.onDestroy();
            customJavaScript = null;
        }
        super.onDestroy();
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode,  Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (customJavaScript != null) {
            customJavaScript.onActivityResult(requestCode,data);
        }
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK) {
            webView.loadUrl("javascript:backPre()");
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }
}
