package com.aiyingli.imoney;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;

import androidx.fragment.app.Fragment;

import com.aiyingli.ibxmodule.ActUtil;
import com.aiyingli.ibxmodule.LogUtil;
import com.aiyingli.ibxmodule.MyJavascript;
import com.aiyingli.ibxmodule.WebActivity;
import com.aiyingli.ibxmodule.service.DownFileService;
import com.aiyingli.ibxmodule.service.GetAppRunningTimeService;
import com.aiyingli.ibxmodule.utils.Base64;
import com.aiyingli.ibxmodule.utils.DeviceUtil;
import com.aiyingli.ibxmodule.utils.IBXAppUtils;
import com.aiyingli.ibxmodule.utils.IBXSdkUtil;
import com.aiyingli.ibxmodule.utils.IBXToastUtil;
import com.aiyingli.ibxmodule.utils.MarketUtils;
import com.ayl.deviceinfo.BaseInfo;
import com.ayl.deviceinfo.BatteryInfo;
import com.ayl.deviceinfo.NetInfo;
import com.ayl.deviceinfo.util.AllInfo;
import com.ayl.deviceinfo.util.NetWorkSpeedUtils;
import com.donkingliang.imageselector.utils.ImageUtil;
import com.donkingliang.imageselector.utils.UriUtils;

import org.json.JSONObject;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * 请自行实现 com.aiyingli.ibxmodule.MyJavascript 中 javaScript 相关内容，这里只做参考
 */
public class CustomJavaScript implements DownFileService.onDownloadListener {

    public static final String NAME_SPACE = "aibianxian";

    private WeakReference<WebView> mWebView;
    private WeakReference<Activity> mContext;
    public String packageName;
    public String appUsagePackageName;
    public boolean needCollectData = false;

    public CustomJavaScript(WebView webView, Activity activity) {
        this.mWebView = new WeakReference(webView);
        this.mContext = new WeakReference(activity);
        DownFileService.listener = this;
    }

    public void onDestroy() {
        if (this.mWebView != null) {
            this.mWebView.clear();
            this.mWebView = null;
        }

        if (this.mContext != null) {
            this.mContext.clear();
            this.mContext = null;
        }
        DownFileService.listener = null;
    }

    public void onActivityResult(int requestCode, Intent data) {
        try {

            if (requestCode == 1 && data != null) {
                List<String> list = data.getStringArrayListExtra("select_result");
                if (list != null && list.size() > 0) {
                    Uri bmUri = UriUtils.getImageContentUri((Context) this.mContext.get(), (String) list.get(0));
                    Bitmap bitmap = ImageUtil.getBitmapFromUri((Context) this.mContext.get(), bmUri);
                    String bmBase64 = com.aiyingli.ibxmodule.utils.ImageUtil.bitmapToBase64(bitmap);
                    IBXAppUtils.runInUiThread(() -> {

                        ((WebView) this.mWebView.get()).loadUrl("javascript:imagePicked('" + bmBase64 + "')");
                    });
                }
            } else if (requestCode == 2) {
                if (!ActUtil.checkAppHaveUsagePermission((Context) this.mContext.get())) {
                    IBXToastUtil.showToast((Context) this.mContext.get(), "请授予查看APP使用情况的权限");
                } else {
                    this.backAppUsageData();
                }
            }

        } catch (Exception var7) {
            var7.printStackTrace();
        }

    }

    public void backAppUsageData() {
        if (this.needCollectData) {
            long usingTime;
            if (Build.VERSION.SDK_INT < 21) {
                usingTime = GetAppRunningTimeService.appRunningTime / 1000L;
            } else {
                usingTime = ActUtil.findUsages((Context) this.mContext.get(), this.appUsagePackageName) / 1000L;
            }

            IBXAppUtils.runInUiThread(() -> {

                ((WebView) this.mWebView.get()).loadUrl("javascript:appRunTime('" + this.appUsagePackageName + "','" + usingTime + "')");

            });
        }

    }

    /***
     * 关闭 爱变现 页面
     */
    @JavascriptInterface
    public void ibx_close() {
        mContext.get().finish();
    }

    @JavascriptInterface
    public void ibx_openUrl(String url) {
        ActUtil.openBrowser(mContext.get(), url);
    }

    @JavascriptInterface
    public void ibx_push(String url, int type) {
        LogUtil.info(new Object[]{"url", url, "type", type});
        try {
            WebActivity.startWeb(mContext.get(), type, url);
        } catch (Exception var4) {
            var4.printStackTrace();
        }
    }
    /***
     * 检查 app 是否安装
     * 调用
     * webView.loadUrl("javascript:appInstalled(" + (isInstalled ? "1)" : "0)"))
     * 返回给H5 结果
     * @param packageName 包名
     */
    @JavascriptInterface
    public void ibx_CheckInstall(String packageName) {
        this.packageName = packageName;
        mWebView.get().loadUrl("javascript:appInstalled(" + (IBXAppUtils.isApkInstalled(mContext.get(), packageName) ? "1)" : "0)"));
    }

    /**
     * 下载安装 app
     *  调用
     *  webView.loadUrl("javascript:setProgress('" + packName + "'," + progress + ")");
     *  将下载进度返回H5
     *  progress 取值 0-100 为下载进度   -1为下载失败
     * @param url 下载地址
     */
    @JavascriptInterface
    public void ibx_InstallAPP(String url) {
        DownFileService.startActionFoo((Context) this.mContext.get(), this.packageName, url);
    }

    /**
     * 使用浏览器打开 url
     * @param url 指定 url
     */
    @JavascriptInterface
    public void ibx_Browser(String url) {
        ActUtil.openBrowser(mContext.get(), url);
    }

    /***
     * 打开 app
     * @param packageName 包名
     */
    @JavascriptInterface
    public void ibx_OpenAPP(String packageName) {
        IBXAppUtils.startAppByPackageName((Context) this.mContext.get(), packageName);
    }

    /***
     * 在应用市场中打开APP
     * @param packageName APP包名
     * @param marketPackageName 应用市场包名
     */
    @JavascriptInterface
    public void ibx_OpenAppInMarket(String packageName, String marketPackageName) {

        try {

            MarketUtils.getTools().startMarket(mContext.get(), packageName, marketPackageName);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /***
     * 打开应用市场搜索页，填入关键词
     * @param keyWord 关键词
     * @param marketPackageName 应用市场包名
     */
    @JavascriptInterface
    public void ibx_SearchAppInMarket(String marketPackageName,String keyWord) {
        try {
            IBXAppUtils.startMarketForKeyName(mContext.get(),marketPackageName,keyWord);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    /***
     * 从相册选图
     * 调用
     * webView.loadUrl("javascript:imagePicked('" + bmBase64 + "')");
     * 将base64图片数据返回H5
     */
    @JavascriptInterface
    public void ibx_ImagePick() {
        ActUtil.openGallery(mContext.get(), 1);
    }

    /***
     * 获取 app 的试玩时间
     * 调用
     * webView.loadUrl("javascript:appRunTime('" + this.appUsagePackageName + "','" + usingTime + "')");
     * 将试玩时间返回H5
     * 推荐使用 UsageStatsManager (需要权限)
     * @param packageName app 的包名
     */
    @JavascriptInterface
    public void ibx_StartCollect(String packageName) {

        this.needCollectData = true;
        this.appUsagePackageName = packageName;
        boolean enabled = ActUtil.checkAppHaveUsagePermission((Context) this.mContext.get());
        if (!enabled) {
            ActUtil.requestUsagePermission((Activity) this.mContext.get());
        } else {
            this.backAppUsageData();
        }
    }

    /**
     * 检测 app 是否有权限
     * 调用
     * webView.loadUrl("javascript:permissionState('" + (有权限 ? 1 : 0) + "')");
     * 将权限状态返回H5
     * @param permission 权限名称
     */
    @JavascriptInterface
    public void ibx_CheckPermission(String permission) {
        IBXAppUtils.runInUiThread(() -> {

            boolean permissionGranted;
            if ("android.settings.USAGE_ACCESS_SETTINGS".equals(permission)) {
                permissionGranted = ActUtil.checkAppHaveUsagePermission((Context) this.mContext.get());
                ((WebView) this.mWebView.get()).loadUrl("javascript:permissionState('" + (permissionGranted ? 1 : 0) + "')");
                return;
            }

            permissionGranted = IBXAppUtils.lacksPermissions((Context) this.mContext.get(), permission);
            ((WebView) this.mWebView.get()).loadUrl("javascript:permissionState('" + (permissionGranted ? 0 : 1) + "')");

        });
    }

    /***
     * 打开微信小程序
     * @param appId 小程序 appId
     * @param path 小程序 路径
     */
    @JavascriptInterface
    public void ibx_OpenWXMiniProgram(String appId, String path) {

    }

    /**
     * 获取设备信息
     * 调用
     * webView.loadUrl("javascript:deviceInfo('" + deviceInfo + "')");
     * 将设备信息返回H5
     *
     * deviceInfo数据格式为 JsonObject
     *
     * JsonObject.put("phone_brand",         getBrand());//手机品牌
     * JsonObject.put("phone_model",         getModel());//手机型号
     * JsonObject.put("manufacturer",        getManufacturer());//制造商
     * JsonObject.put("system_version_name", getBuildVersion());//系统版本名称 例 6.0  4.4
     * JsonObject.put("system_api_version",  getBuildLevel());//系统api版本 例 23 17
     *
     */
    @JavascriptInterface
    public void ibx_ObtainDeviceInfo() {
        IBXAppUtils.runInUiThread(() -> {
                ((WebView) this.mWebView.get()).loadUrl("javascript:deviceInfo('" + DeviceUtil.obtainSystemInfo() + "')");
        });
    }

    /***
     * 获取SDK版本
     * 可以不实现
     */
    @JavascriptInterface
    public void ibx_ObtainSDKInfo() {
        IBXAppUtils.runInUiThread(() -> {
                ((WebView) this.mWebView.get()).loadUrl("javascript:sdkInfo('" + IBXSdkUtil.getSDKInfo() + "')");
        });
    }

    @JavascriptInterface
    public void ibx_ObtainBaseInfo(String str) {
        IBXAppUtils.runInUiThread(() -> {

                try {
                    AllInfo.InfoBuilder infoBuilder = (new AllInfo.InfoBuilder((Context)this.mContext.get())).addClientId(str);
                    List<BaseInfo> allInfo = infoBuilder.getAllInfo();
                    Iterator var4 = allInfo.iterator();

                    while(var4.hasNext()) {
                        BaseInfo info = (BaseInfo)var4.next();
                        if (info instanceof NetInfo) {
                            info.getMap().put("downloadSpeed", (float) NetWorkSpeedUtils.getMaxSpeed() * 1.0F / 1024.0F);
                        }
                    }

                    BatteryInfo batteryInfo = new BatteryInfo();
                    batteryInfo.buildParams();
                    allInfo.add(batteryInfo);
                    infoBuilder.addInfo(batteryInfo);
                    final Map<String, Object> map = new HashMap();
                    Iterator var6 = allInfo.iterator();

                    while(var6.hasNext()) {
                        BaseInfo baseInfo = (BaseInfo)var6.next();
                        map.putAll(baseInfo.getMap());
                    }

                    IBXAppUtils.runInUiThread(new Runnable() {
                        public void run() {

                                String s = (new JSONObject(map)).toString();
                                LogUtil.info("base Info = " + s);
                                (mWebView.get()).loadUrl("javascript:baseInfo('" + Base64.getEncoder().encodeToString(s.getBytes()) + "')");


                        }
                    });
                } catch (Exception var8) {
                    var8.printStackTrace();
                }

        });
    }

    @Override
    public void progress(String packName, int progress) {
        IBXAppUtils.runInUiThread(() -> {
            ((WebView) this.mWebView.get()).loadUrl("javascript:setProgress('" + packName + "'," + progress + ")");
        });

    }

    @Override
    public void onFailed(String packName, Throwable e) {

        IBXAppUtils.runInUiThread(() -> {

                ((WebView) this.mWebView.get()).loadUrl("javascript:setProgress('" + packName + "',-1)");

        });
        IBXToastUtil.showToast((Context) this.mContext.get(), "下载失败");
    }

    @Override
    public void completed(String packageName, String fileAbsPath) {
        IBXAppUtils.runInUiThread(() -> {
            ((WebView) this.mWebView.get()).loadUrl("javascript:setProgress('" + packageName + "'," + 100 + ")");
        });
        IBXAppUtils.installAPK((Context) this.mContext.get(), new File(fileAbsPath));
    }

}
