package com.aiyingli.imoney;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class ListH5Activity extends Activity {
    public static final String TAG = "ListH5Activity";
    public static final String LIST_URL = "https://api.aibianxian.net/igame/api/v1.0/cplApi/listGameByTargetId";
    public static final String TOKEN_URL = "https://api.aibianxian.net/igame/api/v1.0/cplApi/access";

    private final List<ListItem> dataList = new ArrayList<>();
    private RvAdapter rvAdapter;
    private OkHttpClient.Builder builder;
    private static String token = "";

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.activity_list_h5);

        RecyclerView dataView = findViewById(R.id.dataView);
        dataView.setLayoutManager(new LinearLayoutManager(this));
        rvAdapter = new RvAdapter();
        dataView.setAdapter(rvAdapter);

        initOkHttp();

        getToken();
        getList();
    }



    private void initOkHttp() {

        builder = new OkHttpClient.Builder()
                .connectTimeout(5, TimeUnit.SECONDS)
                .readTimeout(5, TimeUnit.SECONDS)
                .writeTimeout(5, TimeUnit.SECONDS);
    }

    private void getToken() {
        OkHttpClient okHttpClient = builder.build();

        String device = "android";

        FormBody formBody = new FormBody
                .Builder()
                .add("app_key", Main2Activity.appKey)
                .add("device", device)
                .add("device_info", Main2Activity.mDeviceInfo)
                .add("target_id", Main2Activity.targetId)
                .build();

        Request request = new Request
                .Builder()
                .post(formBody)//Post请求的参数传递
                .url(TOKEN_URL)
                .build();

        Call call = okHttpClient.newCall(request);
        call.enqueue(new Callback() {
            @Override
            public void onFailure(Call call, IOException e) {
                Log.d(TAG, " failed ");
            }

            @Override
            public void onResponse(Call call, Response response) throws IOException {
                String string = response.body().string();
                Log.d(TAG, " onResponse " + string);
                try {

                    //数据格式 {"code":"200","data":{"token":"*****"}}

                    JSONObject jsonObject = new JSONObject(string);
                    JSONObject dataObj = jsonObject.getJSONObject("data");
                    token = dataObj.getString("token");

                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getList() {


        OkHttpClient okHttpClient = builder.build();

        HttpUrl.Builder httpUrlBuilder = HttpUrl.parse(LIST_URL).newBuilder();
        httpUrlBuilder.addQueryParameter("pageNum", "1");
        httpUrlBuilder.addQueryParameter("pageSize", "10");
        httpUrlBuilder.addQueryParameter("appKey", Main2Activity.appKey);
        httpUrlBuilder.addQueryParameter("type", "");//目前只有：战斗，捕鱼，休闲，不传显示全部
        httpUrlBuilder.addQueryParameter("targetId", Main2Activity.targetId);

        Request okRequest = new Request.Builder()
                .url(httpUrlBuilder.build())
                .get()
                .build();

        Call newCall = okHttpClient.newCall(okRequest);
        newCall.enqueue(new Callback() {
            @Override
            public void onFailure(Call call, IOException e) {
                Log.d(TAG, " failed ");
            }

            @Override
            public void onResponse(Call call, Response response) throws IOException {
                String bodyString = response.body().string();
                Log.d(TAG, " onResponse " + bodyString);
                try {

                    JSONObject jsonObject = new JSONObject(bodyString);
                    JSONObject dataObj = jsonObject.getJSONObject("data");
                    JSONArray records = dataObj.getJSONArray("records");
                    for (int i = 0; i < records.length(); i++) {
                        JSONObject object = (JSONObject) records.get(i);
                        String name = object.getString("name");
                        String gameDetailUrl = object.getString("gameDetailUrl");
                        String iconLink = object.getString("iconLink");
                        ListItem item = new ListItem();
                        item.setName(name);
                        item.setIconLink(iconLink);
                        item.setDetailUrl(gameDetailUrl);
                        dataList.add(item);
                    }
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            rvAdapter.notifyDataSetChanged();
                        }
                    });

                } catch (Exception e) {
                    e.printStackTrace();
                }

            }
        });


    }

    static class ListItem {
        String name;
        String detailUrl;
        String iconLink;

        public String getIconLink() {
            return iconLink;
        }

        public void setIconLink(String iconLink) {
            this.iconLink = iconLink;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDetailUrl() {
            return detailUrl;
        }

        public void setDetailUrl(String detailUrl) {
            this.detailUrl = detailUrl;
        }
    }

    private static String buildDetailUrl(String srcUrl) {
        String url = srcUrl + "?token=" + token + "&ibxsdk=android&headerShow=1";
        Log.d("urlibx",url);
        return url;
    }

    class RvAdapter extends RecyclerView.Adapter<RvAdapter.Holder> {


        @NonNull
        @Override
        public Holder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
            TextView textView = new TextView(ListH5Activity.this);
            textView.setPadding(10, 10, 10, 10);
            textView.setElevation(10);

            textView.setLayoutParams(params);
            textView.setGravity(Gravity.CENTER);

            LinearLayout linearLayout = new LinearLayout(ListH5Activity.this);
            ImageView imageView = new ImageView(ListH5Activity.this);
            LinearLayout.LayoutParams paramsLinear = new LinearLayout.LayoutParams(100, 100);
            paramsLinear.setMargins(10,10,10,10);


            linearLayout.addView(imageView,paramsLinear);
            linearLayout.addView(textView);
            linearLayout.setPadding(10,10,10,10);
            linearLayout.setBackgroundResource(R.drawable.text_item);

            RecyclerView.LayoutParams rvParam = new RecyclerView.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
            rvParam.bottomMargin = 10;
            rvParam.leftMargin = 10;
            rvParam.rightMargin = 10;
            linearLayout.setLayoutParams(rvParam);

            return new Holder(linearLayout);
        }

        @Override
        public void onBindViewHolder(@NonNull Holder holder, final int position) {
            ((TextView)holder.itemView.getChildAt(1)).setText(dataList.get(position).getName());
            ImageView imageView = (ImageView)holder.itemView.getChildAt(0);
            Glide.with(imageView).load(dataList.get(position).getIconLink()).into(imageView);
            holder.itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    ListH5FragmentActivity.start(ListH5Activity.this, buildDetailUrl(dataList.get(position).getDetailUrl()));
                }
            });
        }

        @Override
        public int getItemCount() {
            return dataList.size();
        }

        class Holder extends RecyclerView.ViewHolder {
            LinearLayout itemView;

            public Holder(@NonNull LinearLayout itemView) {
                super(itemView);
                this.itemView = itemView;
            }
        }
    }
}
