package com.aiyingli.imoney;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.KeyEvent;

import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentTransaction;

import com.aiyingli.ibxmodule.IBXFragment;
import com.aiyingli.ibxmodule.IBXSdk;

public class ListH5FragmentActivity extends FragmentActivity {

    private IBXFragment ibxFragment;

    public static void start(Activity activity , String url) {
        Intent intent = new Intent(activity,ListH5FragmentActivity.class);
        intent.putExtra("url", url);
        activity.startActivity(intent);
    }
    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);


        setContentView(R.layout.activity_h5_fragment);

        IBXSdk.getInstance().initApplication(getApplication());/// todo 必须

        String url = getIntent().getStringExtra("url");
        ibxFragment = IBXFragment.getInstance(url);

        FragmentTransaction fragmentTransaction = getSupportFragmentManager().beginTransaction();
        fragmentTransaction.add(R.id.flFragment, ibxFragment);
        fragmentTransaction.commitAllowingStateLoss();
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK) {
            ibxFragment.onKeyDown(keyCode,event);
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }
}
