package com.aiyingli.imoney;

import android.Manifest;
import android.app.Activity;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Toast;

import com.aiyingli.ibxmodule.IBXSdk;
import com.aiyingli.ibxmodule.LogUtil;
import com.ayl.deviceinfo.util.IMEIUtil;
import com.ayl.deviceinfo.util.OAIDHelper;
import com.aylces.iwalk.CesCore;

import java.lang.reflect.Method;

public class Main2Activity extends Activity implements View.OnClickListener {
    
    // TODO 请先申请msa证书，具体方式见 MSA_doc.html
    public static final String OAID_CERT_FILE_NAME = "com.aiyingli.imoney1_support.cert.pem";
    public static final String OAID_OAID_LIB_NAME = "msaoaidsec";// OAID aar文件中jni目录下,libnllvmxxxxxx.so文件，即去掉lib前缀和.so后缀剩下的内容
    public static final int OAID_OAID_HELPER_VERSION = 20211214;//官方DemoHelper.java中给出的版本号
    
    public static String appKey = "142792768";//TODO 爱变现平台的应用 appkey
    public static String secret = "1c03e83281b66486"; //TODO 爱变现平台的应用 secret
    public static String targetId = "12345";// 接入平台的用户唯一标志 最长64位
    public static String mDeviceInfo = "imeiOrOAID";//TODO 必须要取得  Android10以下使用 imei； Android10及以上使用OAID
    
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main2);
        
        //  6.0 <= APP_TARGET_SDK_VERSION <= 9.0
        if (Build.VERSION_CODES.M <= Build.VERSION.SDK_INT && Build.VERSION.SDK_INT < Build.VERSION_CODES.Q) {
            requestPermissions(new String[]{Manifest.permission.READ_PHONE_STATE}, 1234);
        } else {
            IBXSdk.getInstance().initApplication(getApplication());
            IBXSdk.getInstance().setOAIDInfo(OAID_CERT_FILE_NAME,OAID_OAID_LIB_NAME,OAID_OAID_HELPER_VERSION);
            getDeviceId();
        }


        
        findViewById(R.id.btn1).setOnClickListener(this);
        findViewById(R.id.btn2).setOnClickListener(this);
        findViewById(R.id.btn3).setOnClickListener(this);
        findViewById(R.id.btn4).setOnClickListener(this);
        findViewById(R.id.btn5).setOnClickListener(this);
        findViewById(R.id.btn6).setOnClickListener(this);
        findViewById(R.id.btn7).setOnClickListener(this);
        findViewById(R.id.btn8).setOnClickListener(this);
     
    }
    
    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        for (int i = 0; i < permissions.length; i++) {
            
            if (Manifest.permission.READ_PHONE_STATE.equals(permissions[i]) && grantResults[i] == PackageManager.PERMISSION_GRANTED) {
                getDeviceId();
            } else {
                Toast.makeText(this, "请先获取权限", Toast.LENGTH_SHORT).show();
            }
        }
    }
    
    @Override
    public void onClick(View v) {
        IBXSdk.getInstance().setHighCostState(false);
        IBXSdk.getInstance().showLog(true);
        IBXSdk.getInstance().setDebug(true);//测试地址
        
        switch (v.getId()) {
            case R.id.btn1:
                IBXSdk.getInstance().init(getApplication(), appKey, secret, targetId)
                        .setOAIDInfo(OAID_CERT_FILE_NAME,OAID_OAID_LIB_NAME,OAID_OAID_HELPER_VERSION)
                        .start(this);
                
//                IBXSdk.getInstance().init(getApplication(), appKey, targetId, mDeviceInfo, secret, null);
//                IBXSdk.getInstance().start(this);
                
                break;
            
            case R.id.btn2:
                IBXSdk.getInstance()
                        .init(getApplication(), appKey, secret, targetId)
                        .setHighCostState(true)
                        .start(this);
                break;
                
            case R.id.btn3:
                startActivity(new Intent(this, Tab1Activity.class));
                break;
                
            case R.id.btn4:
                startActivity(new Intent(Main2Activity.this, ListH5Activity.class));
                break;
                
            case R.id.btn5:
                startActivity(new Intent(this, CpaAsoListActivity.class));
                break;
                
            case R.id.btn6:
                startActivity(new Intent(Main2Activity.this, CustomActivity.class));
                break;
            
            case R.id.btn7:

                startActivity(new Intent(this, Button7Activity.class));
                break;
    
            case R.id.btn8:
                IBXSdk.getInstance()
                        .init(getApplication(),appKey,targetId,mDeviceInfo,secret)
                        .start(this);
                break;
            default:
                break;
        }
    }
    
    private void getDeviceId() {
        final Application application = getApplication();
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.Q) {
            mDeviceInfo = IMEIUtil.getIMEI(application);
        } else {
            //异步获取oaid
            OaidHelper oaidHelper = new OaidHelper(new OaidHelper.AppIdsUpdater() {
                @Override
                public void onIdsValid(String ids) {
                }

                @Override
                public void onOaid(String oaid) {
                    mDeviceInfo = oaid;
                    Log.d("Main2Activity", "test_onOaid: "+oaid);
                }
            });
            oaidHelper.getDeviceIds(getApplicationContext());
        }
    }
}