package com.aiyingli.imoney;

import android.os.Bundle;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioGroup;
import android.widget.TextView;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;

import com.aiyingli.ibxmodule.IBXFragment;
import com.aiyingli.ibxmodule.IBXListener;
import com.aiyingli.ibxmodule.IBXSdk;

import java.util.ArrayList;
import java.util.List;

import static com.aiyingli.imoney.Main2Activity.appKey;
import static com.aiyingli.imoney.Main2Activity.secret;
import static com.aiyingli.imoney.Main2Activity.targetId;


public class Tab1Activity extends FragmentActivity {
    List<Fragment> fragments = new ArrayList<>();
    @Override
    protected void onCreate( Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_tab);

        //TODO 使用Fragment加载URL，需要自行提前获取设备信息,并初始化
        IBXSdk.getInstance() .init(getApplication(),appKey,targetId, Main2Activity.mDeviceInfo ,secret);
        IBXSdk.getInstance().setIsTabType(true); 
        IBXSdk.getInstance().showLog(true);
        
        IBXSdk.getInstance().post(new IBXListener() {
            @Override
            public void success(String s) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        FragmentManager manager=getSupportFragmentManager();
                        FragmentTransaction fragmentTransaction = manager.beginTransaction();
                        String url = s;
                        IBXFragment fragment = IBXFragment.getInstance(url);
                        EmptyFragment fragment1 = EmptyFragment.getInstance();
                        fragmentTransaction.add(R.id.flFragment,fragment);
                        fragmentTransaction.add(R.id.flFragment,fragment1);
                        fragmentTransaction.show(fragment);
                        fragmentTransaction.hide(fragment1);
                        fragments.add(fragment);
                        fragments.add(fragment1);
                        fragmentTransaction.commitAllowingStateLoss();
                    }
                });

            }

            @Override
            public void failed(Object o) {
                Log.e("","");
            }
        });
       
        /*IBXSdk.getInstance().requestIBXHighUrl(new IBXListener() {
            @Override
            public void success(String s) {
                FragmentTransaction fragmentTransaction = getFragmentManager().beginTransaction();
                String url = s;
                IBXFragment fragment = IBXFragment.getInstance(url);
                EmptyFragment fragment1 = EmptyFragment.getInstance();
                fragmentTransaction.add(R.id.flFragment,fragment);
                fragmentTransaction.add(R.id.flFragment,fragment1);
                fragmentTransaction.show(fragment);
                fragmentTransaction.hide(fragment1);
                fragments.add(fragment);
                fragments.add(fragment1);
                fragmentTransaction.commitAllowingStateLoss();
            }
    
            @Override
            public void failed(Object o) {
        
            }
        });*/
        
        
        

        RadioGroup rgTab = findViewById(R.id.rgTab);
        rgTab.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(RadioGroup group, int checkedId) {
                if (checkedId == R.id.rb1) {
                    toggle(0);
                } else {
                    toggle(1);
                }
            }
        });
    }

    private void toggle(int index) {
        FragmentTransaction fragmentTransaction = getSupportFragmentManager().beginTransaction();

        if (index == 0) {
            fragmentTransaction.hide(fragments.get(1));
            fragmentTransaction.show(fragments.get(0));
        } else {
            fragmentTransaction.hide(fragments.get(0));
            fragmentTransaction.show(fragments.get(1));
        }
        fragmentTransaction.commitAllowingStateLoss();

    }


    public static class EmptyFragment extends Fragment {
        public static EmptyFragment getInstance() {
            return new EmptyFragment();
        }
        @Override
        public View onCreateView(LayoutInflater inflater,  ViewGroup container, Bundle savedInstanceState) {
            TextView textView = new TextView(getActivity());
            textView.setText("empty");
            textView.setGravity(Gravity.CENTER);
            return textView;
        }
    }
}
